/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.models;

import com.skillforge.models.SkillType;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerProfile {
    private final UUID playerId;
    private final String playerName;
    private final Map<SkillType, Integer> skillLevels;
    private final Map<SkillType, Long> skillExperience;
    private final Map<SkillType, Long> abilityCooldowns;
    private final Set<SkillType> activeAbilities;
    private UUID partyId;
    private long powerLevel;
    private long totalExperience;

    public PlayerProfile(UUID playerId, String playerName) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.skillLevels = new ConcurrentHashMap<SkillType, Integer>();
        this.skillExperience = new ConcurrentHashMap<SkillType, Long>();
        this.abilityCooldowns = new ConcurrentHashMap<SkillType, Long>();
        this.activeAbilities = ConcurrentHashMap.newKeySet();
        for (SkillType skill : SkillType.values()) {
            this.skillLevels.put(skill, 1);
            this.skillExperience.put(skill, 0L);
        }
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getSkillLevel(SkillType skill) {
        return this.skillLevels.getOrDefault((Object)skill, 1);
    }

    public void setSkillLevel(SkillType skill, int level) {
        this.skillLevels.put(skill, level);
        this.calculatePowerLevel();
    }

    public long getSkillExperience(SkillType skill) {
        return this.skillExperience.getOrDefault((Object)skill, 0L);
    }

    public void addSkillExperience(SkillType skill, long experience) {
        long currentExp = this.getSkillExperience(skill);
        this.skillExperience.put(skill, currentExp + experience);
        this.totalExperience += experience;
        this.calculatePowerLevel();
    }

    public boolean isAbilityOnCooldown(SkillType skill) {
        Long cooldownEnd = this.abilityCooldowns.get((Object)skill);
        if (cooldownEnd == null) {
            return false;
        }
        return System.currentTimeMillis() < cooldownEnd;
    }

    public void setAbilityCooldown(SkillType skill, long cooldownDuration) {
        this.abilityCooldowns.put(skill, System.currentTimeMillis() + cooldownDuration * 1000L);
    }

    public long getAbilityCooldownRemaining(SkillType skill) {
        Long cooldownEnd = this.abilityCooldowns.get((Object)skill);
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = cooldownEnd - System.currentTimeMillis();
        return Math.max(0L, remaining / 1000L);
    }

    public boolean hasActiveAbility(SkillType skill) {
        return this.activeAbilities.contains((Object)skill);
    }

    public void activateAbility(SkillType skill) {
        this.activeAbilities.add(skill);
    }

    public void deactivateAbility(SkillType skill) {
        this.activeAbilities.remove((Object)skill);
    }

    public UUID getPartyId() {
        return this.partyId;
    }

    public void setPartyId(UUID partyId) {
        this.partyId = partyId;
    }

    public boolean hasParty() {
        return this.partyId != null;
    }

    public long getPowerLevel() {
        return this.powerLevel;
    }

    public long getTotalExperience() {
        return this.totalExperience;
    }

    private void calculatePowerLevel() {
        this.powerLevel = this.skillLevels.values().stream().mapToInt(Integer::intValue).sum();
    }
}

