/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.utils;

public class ExperienceUtils {
    public static int getLevel(long experience) {
        if (experience < 0L) {
            return 1;
        }
        return (int)Math.floor(Math.sqrt((double)experience / 1020.0) + 1.0);
    }

    public static long getExperienceForLevel(int level) {
        if (level <= 1) {
            return 0L;
        }
        return (long)Math.pow(level - 1, 2.0) * 1020L;
    }

    public static long getExperienceToNextLevel(long currentExperience) {
        int currentLevel = ExperienceUtils.getLevel(currentExperience);
        long nextLevelExperience = ExperienceUtils.getExperienceForLevel(currentLevel + 1);
        return nextLevelExperience - currentExperience;
    }

    public static double getProgressToNextLevel(long currentExperience) {
        int currentLevel = ExperienceUtils.getLevel(currentExperience);
        long currentLevelExperience = ExperienceUtils.getExperienceForLevel(currentLevel);
        long nextLevelExperience = ExperienceUtils.getExperienceForLevel(currentLevel + 1);
        double progress = (double)(currentExperience - currentLevelExperience) / (double)(nextLevelExperience - currentLevelExperience);
        return Math.max(0.0, Math.min(1.0, progress));
    }
}

