/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.utils;

import com.skillforge.models.SkillType;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MessageUtils {
    public static void sendLevelUpMessage(Player player, SkillType skill, int level) {
        String message = String.valueOf(ChatColor.GREEN) + "\u2726 " + String.valueOf(ChatColor.GRAY) + "You reached " + String.valueOf(ChatColor.YELLOW) + skill.getDisplayName() + String.valueOf(ChatColor.GRAY) + " level " + String.valueOf(ChatColor.YELLOW) + level + String.valueOf(ChatColor.GRAY) + "! " + String.valueOf(ChatColor.GREEN) + "\u2726";
        player.sendMessage(message);
        player.sendTitle(String.valueOf(ChatColor.GOLD) + "LEVEL UP!", String.valueOf(ChatColor.YELLOW) + skill.getDisplayName() + " " + level, 10, 40, 10);
    }

    public static void sendExperienceMessage(Player player, SkillType skill, long experience) {
        String message = String.valueOf(ChatColor.AQUA) + "+" + experience + " " + skill.getDisplayName() + " XP";
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }

    public static void sendAbilityActivatedMessage(Player player, String abilityName, int duration) {
        String message = String.valueOf(ChatColor.GOLD) + "\u26a1 " + String.valueOf(ChatColor.YELLOW) + MessageUtils.formatAbilityName(abilityName) + String.valueOf(ChatColor.GOLD) + " activated for " + duration + " seconds! " + String.valueOf(ChatColor.GOLD) + "\u26a1";
        player.sendMessage(message);
        player.sendTitle(String.valueOf(ChatColor.GOLD) + "ABILITY ACTIVATED!", String.valueOf(ChatColor.YELLOW) + MessageUtils.formatAbilityName(abilityName), 5, 30, 5);
    }

    public static void sendAbilityUnlockedMessage(Player player, SkillType skill, String abilityName) {
        String message = String.valueOf(ChatColor.GREEN) + "\u2726 " + String.valueOf(ChatColor.GRAY) + "You unlocked the " + String.valueOf(ChatColor.YELLOW) + MessageUtils.formatAbilityName(abilityName) + String.valueOf(ChatColor.GRAY) + " ability for " + String.valueOf(ChatColor.YELLOW) + skill.getDisplayName() + String.valueOf(ChatColor.GRAY) + "! " + String.valueOf(ChatColor.GREEN) + "\u2726";
        player.sendMessage(message);
    }

    public static void sendAbilityReadyMessage(Player player, SkillType skill) {
        String message = String.valueOf(ChatColor.GREEN) + "\u26a1 " + String.valueOf(ChatColor.GRAY) + "Your " + String.valueOf(ChatColor.YELLOW) + skill.getDisplayName() + String.valueOf(ChatColor.GRAY) + " ability is ready! " + String.valueOf(ChatColor.GREEN) + "\u26a1";
        player.sendMessage(message);
    }

    private static String formatAbilityName(String abilityName) {
        String[] words = abilityName.replace("-", " ").replace("_", " ").split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    public static String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

