/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.explosionbreaksnoblock;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockRemoveCache {
    public static final Map<ResourceKey<Level>, Map<BlockPos, String>> blockRemoved = new HashMap<ResourceKey<Level>, Map<BlockPos, String>>();

    public static void record(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        blockRemoved.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new HashMap()).put(pos, BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString());
    }

    public static String getBlockId(Level level, BlockPos pos) {
        return ((Map)blockRemoved.getOrDefault(level.dimension(), new HashMap())).getOrDefault(pos, BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(pos).getBlock()).toString());
    }

    public static String getBlockId(Level level, Object ... pos) {
        BlockPos blockPos = BlockRemoveCache.toBlockPos(pos);
        if (blockPos == null) {
            return "minecraft:air";
        }
        return BlockRemoveCache.getBlockId(level, blockPos);
    }

    public static BlockPos toBlockPos(Object ... pos) {
        if (pos.length == 3) {
            return new BlockPos(BlockRemoveCache.floorToInt(pos[0]), BlockRemoveCache.floorToInt(pos[1]), BlockRemoveCache.floorToInt(pos[2]));
        }
        if (pos.length == 1) {
            Object object = pos[0];
            if (object instanceof BlockPos) {
                BlockPos blockPos = (BlockPos)object;
                return blockPos;
            }
            object = pos[0];
            if (object instanceof Vec3) {
                Vec3 vec3 = (Vec3)object;
                return new BlockPos(BlockRemoveCache.floorToInt(vec3.x), BlockRemoveCache.floorToInt(vec3.y), BlockRemoveCache.floorToInt(vec3.z));
            }
        }
        return null;
    }

    private static int floorToInt(Object value) {
        if (value instanceof Byte) {
            return (int)Math.floor(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return (int)Math.floor(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return (int)Math.floor(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return (int)Math.floor(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return (int)Math.floor(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return (int)Math.floor((Double)value);
        }
        return 0;
    }

    public static boolean isBlockInTag(String tagName, Level level, Object ... pos) {
        String tag = tagName.replace("#", "");
        TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)tag));
        BlockState state = ((Block)BuiltInRegistries.BLOCK.getValue(ResourceLocation.parse((String)BlockRemoveCache.getBlockId(level, pos)))).defaultBlockState();
        return state.is(tagKey);
    }

    public static void onTick(Level level) {
        if (!level.isClientSide() && level.dimension() == Level.OVERWORLD) {
            blockRemoved.clear();
        }
    }
}

