/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.explosionbreaksnoblock;

import com.amotassic.explosionbreaksnoblock.BlockRemoveCache;
import com.amotassic.explosionbreaksnoblock.EBNBConfig;
import com.amotassic.explosionbreaksnoblock.config.Configuration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    public static final String MOD_ID = "explosionbreaksnoblock";
    public static final String MOD_NAME = "Explosion Breaks No Block";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Explosion Breaks No Block");
    public static Configuration config;
    private static List<String> EBNBList;
    private static List<String> ENIDList;
    private static List<String> EBNBWhiteList;
    private static List<String> ENIDWhiteList;

    public static void init() {
        LOGGER.info("Ciallo\uff5e(\u2220\u00b7\u03c9< )\u2312\u2605");
        Common.loadConfig();
    }

    public static void loadConfig() {
        config = new Configuration(EBNBConfig.class, MOD_ID);
        EBNBList = Common.toList(EBNBConfig.ExplosionBreaksNoBlockList);
        ENIDList = Common.toList(EBNBConfig.ExplosionNoItemDamageList);
        EBNBWhiteList = Common.toList(EBNBConfig.ExplosionBreaksNoBlockWhiteList);
        ENIDWhiteList = Common.toList(EBNBConfig.ExplosionNoItemDamageWhiteList);
    }

    private static List<String> toList(String string) {
        if (string == null || string.isEmpty()) {
            return List.of();
        }
        return Arrays.stream(string.split("[,;]")).map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !Objects.equals(s, "minecraft:air")).collect(Collectors.toList());
    }

    public static boolean cancel(Entity entity, Level level, Object ... pos) {
        if (Common.isInList(EBNBWhiteList, entity, level, pos)) {
            return false;
        }
        if (EBNBConfig.EBNB_ALL) {
            return true;
        }
        return Common.isInList(EBNBList, entity, level, pos);
    }

    public static boolean cancelItemDamageByExplosion(DamageSource source, Level level) {
        if (Common.isInList(ENIDWhiteList, source.getDirectEntity(), level, source.sourcePositionRaw())) {
            return false;
        }
        if (EBNBConfig.ENID_ALL) {
            return true;
        }
        return Common.isInList(ENIDList, source.getDirectEntity(), level, source.sourcePositionRaw());
    }

    private static String getEntityId(Entity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
    }

    private static boolean isEntityInTag(String tagName, Entity entity) {
        String tag = tagName.replace("#", "");
        return entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    private static boolean isInList(List<String> list, Entity entity, Level level, Object ... pos) {
        if (entity != null) {
            if (list.contains(Common.getEntityId(entity))) {
                return true;
            }
            for (String tag : list) {
                if (!tag.startsWith("#") || !Common.isEntityInTag(tag, entity)) continue;
                return true;
            }
        } else {
            if (list.contains(BlockRemoveCache.getBlockId(level, pos))) {
                return true;
            }
            for (String tag : list) {
                if (!tag.startsWith("#") || !BlockRemoveCache.isBlockInTag(tag, level, pos)) continue;
                return true;
            }
        }
        return false;
    }
}

