/*
 * Decompiled with CFR 0.152.
 */
package com.elitemastereric.createsalvage.api.data.recipe;

import com.elitemastereric.createsalvage.content.salvaging.SalvagingRecipe;
import com.elitemastereric.createsalvage.content.salvaging.SalvagingRecipeParams;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SalvagingRecipeGen
extends RecipeProvider {
    protected final String modid;
    protected final List<GeneratedRecipe> recipes = new ArrayList<GeneratedRecipe>();

    public SalvagingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modId) {
        super(output, registries);
        this.modid = modId;
    }

    protected GeneratedRecipe heated(Item ingredient, SalvagingRecipeParams.SalvagingMaterial material, int value, float ratio) {
        return this.create(() -> ingredient, HeatCondition.HEATED, b -> b.material(material).amount((float)value * ratio));
    }

    protected GeneratedRecipe heated(Item ingredient, SalvagingRecipeParams.SalvagingMaterial material, int value) {
        return this.heated(ingredient, material, value, 0.5f);
    }

    protected GeneratedRecipe superheated(Item ingredient, SalvagingRecipeParams.SalvagingMaterial material, int value, float ratio) {
        return this.create(() -> ingredient, HeatCondition.SUPERHEATED, b -> b.material(material).amount((float)value * ratio));
    }

    protected GeneratedRecipe superheated(Item ingredient, SalvagingRecipeParams.SalvagingMaterial material, int value) {
        return this.superheated(ingredient, material, value, 0.5f);
    }

    protected GeneratedRecipe create(String namespace, Supplier<ItemLike> ingredient, HeatCondition requiredHeat, UnaryOperator<SalvagingRecipe.Builder> transform) {
        GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)ingredient.get();
            Object recipePath = RegisteredObjectsHelper.getKeyOrThrow((Item)itemLike.asItem()).getPath();
            switch (requiredHeat) {
                case HEATED: {
                    recipePath = (String)recipePath + "_heated";
                    break;
                }
                case SUPERHEATED: {
                    recipePath = (String)recipePath + "_superheated";
                }
            }
            ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)recipePath);
            if (!Objects.equals(this.modid, "create_salvage")) {
                c = c.withConditions(new ICondition[]{new ModLoadedCondition(this.modid)});
            }
            ((SalvagingRecipe.Builder)transform.apply(this.getBuilder(recipeId).ingredient(itemLike).requiresHeat(requiredHeat))).build(c);
        };
        this.recipes.add(generatedRecipe);
        return generatedRecipe;
    }

    protected GeneratedRecipe create(Supplier<ItemLike> ingredient, HeatCondition requiredHeat, UnaryOperator<SalvagingRecipe.Builder> transform) {
        return this.create(this.modid, ingredient, requiredHeat, transform);
    }

    protected SalvagingRecipe.Serializer getSerializer() {
        return (SalvagingRecipe.Serializer)this.getRecipeType().getSerializer();
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected SalvagingRecipe.Builder getBuilder(ResourceLocation id) {
        return new SalvagingRecipe.Builder(this.getSerializer().factory(), id);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.recipes.forEach(c -> c.register(recipeOutput));
    }

    public String getName() {
        return this.modid + "'s Salvaging recipes";
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(RecipeOutput var1);
    }
}

