/*
 * Decompiled with CFR 0.152.
 */
package com.elitemastereric.createsalvage.data.recipe;

import com.elitemastereric.createsalvage.ModItems;
import com.elitemastereric.createsalvage.data.recipe.CreateSalvageSalvagingRecipeProvider;
import com.elitemastereric.createsalvage.data.recipe.compat.CompatSalvagingRecipeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreateSalvageRecipeProvider
extends RecipeProvider {
    static final List<RecipeProvider> GENERATORS = new ArrayList<RecipeProvider>();

    public CreateSalvageRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ModItems.DIAMOND_NUGGET, (int)9).requires((ItemLike)Items.DIAMOND).unlockedBy("has_diamond", CreateSalvageRecipeProvider.has((ItemLike)Items.DIAMOND)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"create_salvage", (String)"diamond_nuggets_from_diamond"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND).requires(ModItems.DIAMOND_NUGGET, 9).unlockedBy("has_diamond_nugget", CreateSalvageRecipeProvider.has(ModItems.DIAMOND_NUGGET)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"create_salvage", (String)"diamond_from_diamond_nuggets"));
    }

    public static void registerProcessingRecipes(DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        GENERATORS.add(new CreateSalvageSalvagingRecipeProvider(output, registries));
        CompatSalvagingRecipeProvider.generate(GENERATORS, output, registries);
        gen.addProvider(true, new DataProvider(){

            public String getName() {
                return "Create: Salvage's Recipes";
            }

            public CompletableFuture<?> run(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }
}

