/*
 * Decompiled with CFR 0.152.
 */
package com.elitemastereric.createsalvage.compat.jei;

import com.elitemastereric.createsalvage.SalvagingRecipeTypes;
import com.elitemastereric.createsalvage.compat.jei.category.SalvagingCategory;
import com.elitemastereric.createsalvage.content.salvaging.SalvagingRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class CreateMeltingJEI
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"create_salvage", (String)"jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;
    public static IJeiRuntime runtime;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory salvaging = this.builder(SalvagingRecipe.class).addTypedRecipes(SalvagingRecipeTypes.SALVAGING).catalyst(() -> ((BlockEntry)AllBlocks.MECHANICAL_MIXER).get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build("salvaging", SalvagingCategory::new);
    }

    private <T extends Recipe<? extends RecipeInput>> CategoryBuilder<T> builder(Class<T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        CreateMeltingJEI.runtime = runtime;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxColoringRecipeMaker.createRecipes().toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            CreateMeltingJEI.this.allCategories.add(category);
            return category;
        }
    }
}

