/*
 * Decompiled with CFR 0.152.
 */
package com.elitemastereric.createsalvage.content.salvaging;

import com.elitemastereric.createsalvage.CreateSalvage;
import com.elitemastereric.createsalvage.SalvagingRecipeTypes;
import com.elitemastereric.createsalvage.content.salvaging.SalvagingRecipeParams;
import com.google.common.base.Joiner;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.Create;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SalvagingRecipe
implements Recipe<RecipeInput> {
    protected SalvagingRecipeParams params;

    public SalvagingRecipe(SalvagingRecipeParams params) {
        this.params = params;
    }

    public static boolean apply(BasinBlockEntity basin, SalvagingRecipe recipe) {
        return SalvagingRecipe.apply(basin, recipe, false);
    }

    public static boolean apply(BasinBlockEntity basin, SalvagingRecipe recipe, boolean test) {
        Level level = basin.getLevel();
        if (level == null) {
            return false;
        }
        IItemHandler availableItemSlots = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItemSlots == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.getLevel().getBlockState(basin.getBlockPos().below(1)));
        if (!recipe.getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        Ingredient ingredient = recipe.getIngredient();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItemSlots.getSlots()];
            ItemStack extractedItem = null;
            for (int slot = 0; slot < availableItemSlots.getSlots(); ++slot) {
                ItemStack itemToTest;
                if (simulate && availableItemSlots.getStackInSlot(slot).getCount() <= extractedItemsFromSlot[slot] || !ingredient.test(itemToTest = availableItemSlots.extractItem(slot, 1, true))) continue;
                extractedItem = !simulate ? availableItemSlots.extractItem(slot, 1, false) : itemToTest;
                int n = slot;
                extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
            }
            if (extractedItem == null) {
                return false;
            }
            if (simulate) {
                CraftingInput remainderInput = new DummyCraftingContainer(availableItemSlots, extractedItemsFromSlot).asCraftInput();
                float durability = (float)(extractedItem.getMaxDamage() - extractedItem.getDamageValue()) / (float)extractedItem.getMaxDamage();
                CreateSalvage.LOGGER.info("Simulating crafting with durability: {}", (Object)Float.valueOf(durability));
                recipeOutputItems.addAll(recipe.buildResults(durability));
                for (ItemStack stack : recipe.getRemainingItems((RecipeInput)remainderInput)) {
                    if (stack.isEmpty()) continue;
                    recipeOutputItems.add(stack);
                }
            }
            if (basin.acceptOutputs(recipeOutputItems, new ArrayList(), simulate)) continue;
            return false;
        }
        return true;
    }

    public HeatCondition getRequiredHeat() {
        return this.params.requiredHeat;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.getResultItem(provider);
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public Ingredient getIngredient() {
        return this.params.ingredient;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)this.getIngredient(), (Object[])new Ingredient[0]);
    }

    public List<ProcessingOutput> getResults(float durability) {
        return this.params.resultMaterial().calculate(this.params.resultAmount() * durability);
    }

    public List<ProcessingOutput> getResults() {
        return this.getResults(1.0f);
    }

    public List<ItemStack> buildResults(float durability) {
        List<ProcessingOutput> resultsToBuild = this.getResults(durability);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ProcessingOutput output : resultsToBuild) {
            ItemStack stack = output.rollOutput();
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public List<ItemStack> buildResults() {
        return this.buildResults(1.0f);
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.getResults().isEmpty() ? ItemStack.EMPTY : this.getResults().getFirst().getStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return SalvagingRecipeTypes.SALVAGING.getSerializer();
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.params.resultAmount <= 0.0f) {
            errors.add("Recipe has a result amount of 0 items, use a positive decimal value.");
        }
        if (this.params.resultMaterial.nugget != null && this.params.resultMaterial.ratio <= 0) {
            errors.add("Recipe has an invalid nugget:ingot ratio, use a positive integer value.");
        }
        return errors;
    }

    public SalvagingRecipeParams getSalvagingParams() {
        return this.params;
    }

    public RecipeType<?> getType() {
        return SalvagingRecipeTypes.SALVAGING.getType();
    }

    public IRecipeTypeInfo getTypeInfo() {
        return SalvagingRecipeTypes.SALVAGING;
    }

    public static class Serializer
    implements RecipeSerializer<SalvagingRecipe> {
        private final Factory factory;
        private final MapCodec<SalvagingRecipe> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, SalvagingRecipe> streamCodec;

        public Serializer(Factory factory) {
            this.factory = factory;
            this.codec = SalvagingRecipeParams.CODEC.xmap(factory::create, SalvagingRecipe::getSalvagingParams).validate(this::validate);
            this.streamCodec = SalvagingRecipeParams.STREAM_CODEC.map(factory::create, SalvagingRecipe::getSalvagingParams);
        }

        public MapCodec<SalvagingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SalvagingRecipe> streamCodec() {
            return this.streamCodec;
        }

        public DataResult<SalvagingRecipe> validate(SalvagingRecipe recipe) {
            List<String> errors = recipe.validate();
            if (errors.isEmpty()) {
                return DataResult.success((Object)recipe);
            }
            errors.add("SalvagingRecipe failed validation:");
            return DataResult.error(() -> Joiner.on((char)'\n').join((Iterable)errors), (Object)recipe);
        }

        public Factory factory() {
            return this.factory;
        }
    }

    public static class Builder {
        protected ResourceLocation recipeId;
        protected Factory factory;
        protected SalvagingRecipeParams params;
        protected List<ICondition> recipeConditions;

        public Builder(Factory factory, ResourceLocation recipeId) {
            this.recipeId = recipeId;
            this.factory = factory;
            this.params = this.createParams();
            this.recipeConditions = new ArrayList<ICondition>();
        }

        protected SalvagingRecipeParams createParams() {
            return new SalvagingRecipeParams();
        }

        public Builder self() {
            return this;
        }

        public Builder ingredient(ItemLike itemLike) {
            this.params.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{itemLike});
            return this.self();
        }

        public Builder material(Item ingot, @Nullable Item nugget, int ratio) {
            this.params.resultMaterial = new SalvagingRecipeParams.SalvagingMaterial(ingot, nugget, ratio);
            return this.self();
        }

        public Builder material(SalvagingRecipeParams.SalvagingMaterial material) {
            this.params.resultMaterial = material;
            return this.self();
        }

        public Builder requiresHeat(HeatCondition condition) {
            this.params.requiredHeat = condition;
            return this.self();
        }

        public Builder amount(float amount) {
            this.params.resultAmount = amount;
            return this.self();
        }

        public SalvagingRecipe build() {
            return this.factory.create(this.params);
        }

        public void build(RecipeOutput consumer) {
            SalvagingRecipe recipe = this.build();
            IRecipeTypeInfo recipeType = recipe.getTypeInfo();
            ResourceLocation typeId = recipeType.getId();
            ResourceLocation id = this.recipeId.withPrefix(typeId.getPath() + "/");
            List<String> errors = recipe.validate();
            if (!errors.isEmpty()) {
                errors.add(recipe.getClass().getSimpleName() + "with id " + String.valueOf(id) + " failed validation:");
                Create.LOGGER.warn(Joiner.on((char)'\n').join(errors));
            }
            consumer.accept(id, (Recipe)recipe, null, this.recipeConditions.toArray(new ICondition[0]));
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public SalvagingRecipe create(SalvagingRecipeParams var1);
    }
}

