/*
 * Decompiled with CFR 0.152.
 */
package com.elitemastereric.createsalvage.content.salvaging;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipeParams;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SalvagingRecipeParams {
    public static MapCodec<SalvagingRecipeParams> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SalvagingRecipeParams::ingredient), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.HEATED).forGetter(SalvagingRecipeParams::requiredHeat), (App)SalvagingMaterial.CODEC.fieldOf("result_material").forGetter(SalvagingRecipeParams::resultMaterial), (App)Codec.FLOAT.fieldOf("result_amount").forGetter(SalvagingRecipeParams::resultAmount)).apply((Applicative)instance, SalvagingRecipeParams::new));
    public static StreamCodec<RegistryFriendlyByteBuf, SalvagingRecipeParams> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SalvagingRecipeParams::ingredient, (StreamCodec)HeatCondition.STREAM_CODEC, SalvagingRecipeParams::requiredHeat, SalvagingMaterial.STREAM_CODEC, SalvagingRecipeParams::resultMaterial, (StreamCodec)ByteBufCodecs.FLOAT, SalvagingRecipeParams::resultAmount, SalvagingRecipeParams::new);
    protected Ingredient ingredient;
    protected HeatCondition requiredHeat;
    protected SalvagingMaterial resultMaterial;
    protected float resultAmount;

    protected SalvagingRecipeParams() {
    }

    protected SalvagingRecipeParams(Ingredient ingredient, HeatCondition requiredHeat, SalvagingMaterial resultMaterial, float resultAmount) {
        this.ingredient = ingredient;
        this.requiredHeat = requiredHeat;
        this.resultMaterial = resultMaterial;
        this.resultAmount = resultAmount;
    }

    protected final Ingredient ingredient() {
        return this.ingredient;
    }

    protected final HeatCondition requiredHeat() {
        return this.requiredHeat;
    }

    protected final SalvagingMaterial resultMaterial() {
        return this.resultMaterial;
    }

    protected final float resultAmount() {
        return this.resultAmount;
    }

    protected final NonNullList<ProcessingOutput> results() {
        return this.resultMaterial.calculate(this.resultAmount);
    }

    protected ProcessingRecipeParams toBasinParams() {
        return new SalvagingProcessingRecipeParams(this.ingredient, this.requiredHeat, this.results());
    }

    public static class SalvagingMaterial {
        public static MapCodec<SalvagingMaterial> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("ingot").forGetter(SalvagingMaterial::ingot), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("nugget", null).forGetter(SalvagingMaterial::nugget), (App)Codec.INT.optionalFieldOf("ratio", (Object)0).forGetter(SalvagingMaterial::ratio)).apply((Applicative)instance, SalvagingMaterial::new));
        public static StreamCodec<RegistryFriendlyByteBuf, SalvagingMaterial> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), i -> i.ingot, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), i -> i.nugget, (StreamCodec)ByteBufCodecs.INT, i -> i.ratio, SalvagingMaterial::new);
        @NotNull
        protected Item ingot;
        @Nullable
        protected Item nugget;
        protected int ratio;

        public SalvagingMaterial(Item ingot, @Nullable Item nugget, int ratio) {
            this.ingot = ingot;
            this.nugget = nugget;
            this.ratio = ratio;
        }

        public Item ingot() {
            return this.ingot;
        }

        @Nullable
        public Item nugget() {
            return this.nugget;
        }

        public int ratio() {
            return this.ratio;
        }

        public NonNullList<ProcessingOutput> calculate(float amount) {
            float remainder;
            int nuggetAmount;
            NonNullList results = NonNullList.create();
            int ingotAmount = (int)Math.floor(amount);
            if (ingotAmount > 0) {
                results.add((Object)new ProcessingOutput(this.ingot, ingotAmount, 1.0f));
            }
            if (this.nugget != null && (nuggetAmount = (int)Math.floor((remainder = amount - (float)ingotAmount) * (float)this.ratio)) > 0) {
                results.add((Object)new ProcessingOutput(this.nugget, nuggetAmount, 1.0f));
            }
            return results;
        }
    }

    static class SalvagingProcessingRecipeParams
    extends ItemApplicationRecipeParams {
        public SalvagingProcessingRecipeParams(Ingredient ingredient, HeatCondition requiredHeat, NonNullList<ProcessingOutput> results) {
            this.ingredients = NonNullList.of((Object)ingredient, (Object[])new Ingredient[0]);
            this.requiredHeat = requiredHeat;
            this.results = results;
        }
    }
}

