/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.client.favorites;

import com.illusivesoulworks.cherishedworlds.client.favorites.FavoritesList;
import com.illusivesoulworks.cherishedworlds.client.favorites.IFavoritesViewer;
import com.illusivesoulworks.cherishedworlds.integration.ViewerIntegration;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorJoinMultiplayerScreen;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;

public class FavoriteServers
implements IFavoritesViewer<JoinMultiplayerScreen> {
    @Override
    public void init(JoinMultiplayerScreen screen) {
    }

    @Override
    public void draw(int mouseX, int mouseY, GuiGraphics guiGraphics, JoinMultiplayerScreen screen) {
        AccessorJoinMultiplayerScreen accessor = (AccessorJoinMultiplayerScreen)screen;
        ServerSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.children().size(); ++i) {
                ServerSelectionList.Entry entry = (ServerSelectionList.Entry)selectionList.children().get(i);
                if (!(entry instanceof ServerSelectionList.OnlineServerEntry)) continue;
                ServerData serverData = ((ServerSelectionList.OnlineServerEntry)entry).getServerData();
                int top = selectionList.getY();
                int bottom = selectionList.getBottom();
                boolean isFavorite = FavoritesList.contains(serverData.name + serverData.ip);
                this.drawIcon(mouseX, mouseY, guiGraphics, screen, i, isFavorite, top, selectionList.scrollAmount(), bottom);
            }
        }
    }

    @Override
    public void click(int mouseX, int mouseY, JoinMultiplayerScreen screen) {
        AccessorJoinMultiplayerScreen accessor = (AccessorJoinMultiplayerScreen)screen;
        ServerSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.children().size(); ++i) {
                ServerSelectionList.Entry entry = (ServerSelectionList.Entry)selectionList.children().get(i);
                if (!(entry instanceof ServerSelectionList.OnlineServerEntry)) continue;
                ServerData serverData = ((ServerSelectionList.OnlineServerEntry)entry).getServerData();
                boolean isFavorite = FavoritesList.contains(serverData.name + serverData.ip);
                int topOffsetMod = 15;
                int height = 36;
                Pair<Integer, Integer> override = ViewerIntegration.getOverride(height);
                if (override != null) {
                    topOffsetMod = (Integer)override.getFirst();
                    height = (Integer)override.getSecond();
                }
                int top = (int)((double)(selectionList.getY() + topOffsetMod + height * i) - selectionList.scrollAmount());
                int x = screen.width / 2 - this.getHorizontalOffset();
                if (mouseY < top || mouseY > top + 9 || mouseX < x || mouseX > x + 9) continue;
                String s = serverData.name + serverData.ip;
                if (isFavorite) {
                    FavoritesList.remove(s);
                } else {
                    FavoritesList.add(s);
                }
                FavoritesList.save();
                accessor.getSelectionList().updateOnlineServers(screen.getServers());
                ServerSelectionList.Entry selected = (ServerSelectionList.Entry)accessor.getSelectionList().getSelected();
                if (selected instanceof ServerSelectionList.OnlineServerEntry) {
                    FavoriteServers.disableDeletion((ServerSelectionList.OnlineServerEntry)selected, accessor.getDeleteButton());
                }
                return;
            }
        }
    }

    @Override
    public void clicked(JoinMultiplayerScreen screen) {
    }

    @Override
    public int getHorizontalOffset() {
        return 168;
    }

    private static void disableDeletion(ServerSelectionList.OnlineServerEntry entry, Button deleteButton) {
        ServerData serverData = entry.getServerData();
        deleteButton.active = !FavoritesList.contains(serverData.name + serverData.ip);
    }
}

