/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.client.favorites;

import com.illusivesoulworks.cherishedworlds.client.favorites.FavoritesList;
import com.illusivesoulworks.cherishedworlds.client.favorites.IFavoritesViewer;
import com.illusivesoulworks.cherishedworlds.integration.ViewerIntegration;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionList;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionScreen;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.world.level.storage.LevelSummary;

public class FavoriteWorlds
implements IFavoritesViewer<SelectWorldScreen> {
    @Override
    public void init(SelectWorldScreen screen) {
        EditBox textField;
        AccessorWorldSelectionScreen accessor = (AccessorWorldSelectionScreen)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null && (textField = accessor.getSearchBox()) != null) {
            selectionList.updateFilter(textField.getValue());
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, GuiGraphics guiGraphics, SelectWorldScreen screen) {
        AccessorWorldSelectionScreen accessor = (AccessorWorldSelectionScreen)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.children().size(); ++i) {
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.children().get(i);
                if (!(entry instanceof WorldSelectionList.WorldListEntry)) continue;
                WorldSelectionList.WorldListEntry worldListEntry = (WorldSelectionList.WorldListEntry)entry;
                LevelSummary summary = worldListEntry.getLevelSummary();
                int top = selectionList.getY();
                int bottom = selectionList.getBottom();
                boolean isFavorite = FavoritesList.contains(summary.getLevelId());
                this.drawIcon(mouseX, mouseY, guiGraphics, screen, i, isFavorite, top, selectionList.scrollAmount(), bottom);
            }
        }
    }

    @Override
    public void click(int mouseX, int mouseY, SelectWorldScreen screen) {
        AccessorWorldSelectionScreen accessor = (AccessorWorldSelectionScreen)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.children().size(); ++i) {
                AccessorWorldSelectionList accessorWorldSelectionList;
                List<LevelSummary> levelSummaries;
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.children().get(i);
                if (!(entry instanceof WorldSelectionList.WorldListEntry)) continue;
                WorldSelectionList.WorldListEntry worldListEntry = (WorldSelectionList.WorldListEntry)entry;
                LevelSummary summary = worldListEntry.getLevelSummary();
                boolean isFavorite = FavoritesList.contains(summary.getLevelId());
                int topOffsetMod = 15;
                int height = 36;
                Pair<Integer, Integer> override = ViewerIntegration.getOverride(height);
                if (override != null) {
                    topOffsetMod = (Integer)override.getFirst();
                    height = (Integer)override.getSecond();
                }
                int top = (int)((double)(selectionList.getY() + topOffsetMod + height * i) - selectionList.scrollAmount());
                int x = screen.width / 2 - this.getHorizontalOffset();
                if (mouseY < top || mouseY > top + 9 || mouseX < x || mouseX > x + 9) continue;
                String s = summary.getLevelId();
                if (isFavorite) {
                    FavoritesList.remove(s);
                } else {
                    FavoritesList.add(s);
                }
                FavoritesList.save();
                EditBox textField = accessor.getSearchBox();
                String filter = "";
                if (textField != null) {
                    filter = textField.getValue();
                }
                if ((levelSummaries = (accessorWorldSelectionList = (AccessorWorldSelectionList)selectionList).getCurrentlyDisplayedLevels()) != null) {
                    accessorWorldSelectionList.callFillLevels(filter, levelSummaries);
                }
                return;
            }
        }
    }

    @Override
    public void clicked(SelectWorldScreen screen) {
    }

    @Override
    public int getHorizontalOffset() {
        return 148;
    }
}

