/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.client.favorites;

import com.illusivesoulworks.cherishedworlds.integration.ViewerIntegration;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public interface IFavoritesViewer<T extends Screen> {
    public static final ResourceLocation STAR_ICON = ResourceLocation.fromNamespaceAndPath((String)"cherishedworlds", (String)"textures/gui/staricon.png");
    public static final ResourceLocation EMPTY_STAR_ICON = ResourceLocation.fromNamespaceAndPath((String)"cherishedworlds", (String)"textures/gui/emptystaricon.png");

    public void init(T var1);

    public void draw(int var1, int var2, GuiGraphics var3, T var4);

    public void click(int var1, int var2, T var3);

    public void clicked(T var1);

    public int getHorizontalOffset();

    default public void drawIcon(int mouseX, int mouseY, GuiGraphics guiGraphics, T screen, int index, boolean isFavorite, int topOffset, double scrollAmount, int bottom) {
        ResourceLocation icon = isFavorite ? STAR_ICON : EMPTY_STAR_ICON;
        int topOffsetMod = 15;
        int height = 36;
        Pair<Integer, Integer> override = ViewerIntegration.getOverride(height);
        if (override != null) {
            topOffsetMod = (Integer)override.getFirst();
            height = (Integer)override.getSecond();
        }
        int top = (int)((double)(topOffset + topOffsetMod + height * index) - scrollAmount);
        int x = ((Screen)screen).width / 2 - this.getHorizontalOffset();
        if (top < bottom - 8 && top > topOffset) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, icon, x, top, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        if (mouseY >= top && mouseY <= top + 9 && mouseX >= x && mouseX <= x + 9) {
            String suffix = isFavorite ? "unfavorite" : "favorite";
            ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
            MutableComponent component = Component.translatable((String)("selectWorld.cherishedworlds." + suffix));
            components.add(ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText()));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }
}

