/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.renderer.ModRenderType;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Objects;
import net.minecraft.class_10017;
import net.minecraft.class_10725;
import net.minecraft.class_11659;
import net.minecraft.class_11723;
import net.minecraft.class_11724;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.joml.Matrix4f;

public abstract class MobPlaqueRenderer {
    protected static final int FULL_BRIGHTNESS_PACKED_LIGHT = 0xF000F0;
    protected static final int BACKGROUND_BORDER_SIZE = 1;
    protected boolean allowRendering;

    public boolean isRenderingAllowed(MobPlaquesRenderState renderState) {
        return this.allowRendering && this.getValue(renderState) > 0;
    }

    public int getWidth(MobPlaquesRenderState renderState) {
        return class_310.method_1551().field_1772.method_27525((class_5348)this.getComponent(renderState)) + 2;
    }

    public int getHeight(MobPlaquesRenderState renderState) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return 9 + 2;
    }

    public abstract int getValue(MobPlaquesRenderState var1);

    protected class_5250 getTextComponent(MobPlaquesRenderState renderState) {
        return class_2561.method_43470((String)(this.getValue(renderState) + "x"));
    }

    public final class_2561 getComponent(MobPlaquesRenderState renderState) {
        return class_2561.method_43473().method_10852((class_2561)this.getTextComponent(renderState).method_54663(this.getColor(renderState))).method_10852((class_2561)class_2561.method_74062((class_11724)new class_11723(class_10725.field_56385, this.getSprite(renderState))));
    }

    protected int getColor(MobPlaquesRenderState renderState) {
        return class_9848.method_61335((int)-1);
    }

    public void submit(int posX, int posY, class_4587 poseStack, class_11659 submitNodeCollector, class_10017 entityRenderState, MobPlaquesRenderState renderState) {
        this.submitTextBackground(poseStack, posX, posY, submitNodeCollector, entityRenderState, renderState);
        this.submitTextComponent(poseStack, posX, posY, submitNodeCollector, entityRenderState, renderState);
    }

    private void submitTextBackground(class_4587 poseStack, int posX, int posY, class_11659 submitNodeCollector, class_10017 entityRenderState, MobPlaquesRenderState renderState) {
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBackground) {
            int backgroundColor = class_310.method_1551().field_1690.method_19345(0.25f);
            class_1921 renderType = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls ? class_1921.method_49046() : ModRenderType.textBackground();
            submitNodeCollector.method_73483(poseStack, renderType, (pose, vertexConsumer) -> {
                Matrix4f matrix4f = pose.method_23761();
                int minX = posX - this.getWidth(renderState) / 2;
                int minY = posY;
                int maxX = posX + this.getWidth(renderState) / 2;
                int maxY = posY + this.getHeight(renderState);
                int packedLight = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : entityRenderState.field_61820;
                vertexConsumer.method_22918(matrix4f, (float)minX, (float)minY, 0.0f).method_39415(backgroundColor).method_60803(packedLight);
                vertexConsumer.method_22918(matrix4f, (float)minX, (float)maxY, 0.0f).method_39415(backgroundColor).method_60803(packedLight);
                vertexConsumer.method_22918(matrix4f, (float)maxX, (float)maxY, 0.0f).method_39415(backgroundColor).method_60803(packedLight);
                vertexConsumer.method_22918(matrix4f, (float)maxX, (float)minY, 0.0f).method_39415(backgroundColor).method_60803(packedLight);
            });
        }
    }

    private void submitTextComponent(class_4587 poseStack, int posX, int posY, class_11659 submitNodeCollector, class_10017 entityRenderState, MobPlaquesRenderState renderState) {
        int packedLight;
        class_5481 formattedCharSequence = this.getComponent(renderState).method_30937();
        int x = posX - this.getWidth(renderState) / 2 + 1;
        int y = posY + 1 + 1;
        int n = packedLight = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : entityRenderState.field_61820;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            submitNodeCollector.method_73529(1).method_73478(poseStack, (float)x, (float)y, formattedCharSequence, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderTextShadow, class_327.class_6415.field_33994, packedLight, class_9848.method_61330((int)(((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 128 : 32), (int)-1), 0, entityRenderState.field_61821);
        }
        submitNodeCollector.method_73529(1).method_73478(poseStack, (float)x, (float)y, formattedCharSequence, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderTextShadow, class_327.class_6415.field_33993, packedLight, -1, 0, entityRenderState.field_61821);
    }

    protected abstract class_2960 getSprite(MobPlaquesRenderState var1);

    public void setupConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Allow for rendering this type of plaque.").define("allow_rendering", true), v -> {
            this.allowRendering = v;
        });
    }

    public void extractRenderState(class_1309 livingEntity, MobPlaquesRenderState renderState, float partialTick) {
    }

    public abstract String getName();
}

