/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import com.google.common.collect.Lists;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.AirPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ArmorPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.HealthPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ToughnessPlaqueRenderer;
import fuzs.mobplaques.client.helper.EntityVisibilityHelper;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_169;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_897;
import net.minecraft.class_9064;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Quaternionfc;

public class MobPlaqueHandler {
    private static final class_169<MobPlaquesRenderState> RENDER_STATE_PROPERTY = new class_169(MobPlaques.id("render_state"));
    private static final int PLAQUE_HORIZONTAL_DISTANCE = 2;
    private static final int PLAQUE_VERTICAL_DISTANCE = 2;
    public static final List<MobPlaqueRenderer> PLAQUE_RENDERERS = List.of(new HealthPlaqueRenderer(), new AirPlaqueRenderer(), new ArmorPlaqueRenderer(), new ToughnessPlaqueRenderer());

    public static void onExtractRenderState(class_1297 entity, class_10017 entityRenderState, float partialTick) {
        class_1309 livingEntity;
        if (entity instanceof class_1309 && MobPlaqueHandler.canPlaqueRender(livingEntity = (class_1309)entity, partialTick)) {
            MobPlaquesRenderState renderState = new MobPlaquesRenderState();
            RenderStateExtraData.set((class_10017)entityRenderState, RENDER_STATE_PROPERTY, (Object)renderState);
            for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
                mobPlaqueRenderer.extractRenderState(livingEntity, renderState, partialTick);
            }
            if (entityRenderState.field_53337 == null) {
                entityRenderState.field_53337 = class_5244.field_39003;
                entityRenderState.field_53338 = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(partialTick));
            }
        }
    }

    private static boolean canPlaqueRender(class_1309 livingEntity, float partialTick) {
        class_243 nameTagAttachment;
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return false;
        }
        if (livingEntity.method_5805() && ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).isEntityAllowed(livingEntity) && (nameTagAttachment = livingEntity.method_56072().method_55675(class_9064.field_47745, 0, livingEntity.method_5705(partialTick))) != null) {
            return EntityVisibilityHelper.isEntityVisible(livingEntity, partialTick, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntity);
        }
        return false;
    }

    public static EventResult onRenderNameTag(class_897<?, ?> entityRenderer, class_10017 entityRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (entityRenderState.field_53337 != null && RenderStateExtraData.has((class_10017)entityRenderState, RENDER_STATE_PROPERTY)) {
            poseStack.method_22903();
            class_243 nameTagAttachment = entityRenderState.field_53338;
            if (nameTagAttachment != null) {
                poseStack.method_22904(nameTagAttachment.field_1352, nameTagAttachment.field_1351 + 0.5, nameTagAttachment.field_1350);
            }
            poseStack.method_22907((Quaternionfc)cameraRenderState.field_63081);
            float plaqueScale = MobPlaqueHandler.getPlaqueScale(entityRenderState.field_53332);
            poseStack.method_22905(0.025f * plaqueScale, -0.025f * plaqueScale, 0.025f * plaqueScale);
            MobPlaquesRenderState renderState = (MobPlaquesRenderState)RenderStateExtraData.get((class_10017)entityRenderState, RENDER_STATE_PROPERTY);
            int heightOffset = MobPlaqueHandler.computeHeightOffset(renderState, entityRenderState.field_53337, plaqueScale);
            MobPlaqueHandler.renderAllPlaques(entityRenderState, renderState, poseStack, submitNodeCollector, cameraRenderState, heightOffset);
            poseStack.method_22909();
            if (entityRenderState.field_53337 == class_5244.field_39003) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static int computeHeightOffset(MobPlaquesRenderState renderState, class_2561 component, float plaqueScale) {
        int heightOffset = "deadmau5".equals(component.getString()) ? -13 : -3;
        heightOffset -= (int)((float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).offsetHeight * (0.5f / plaqueScale));
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBelowNameTag) {
            heightOffset += (int)(23.0f * (0.5f / plaqueScale));
        } else {
            int plaquesHeight = MobPlaqueHandler.getPlaquesHeight(renderState);
            heightOffset -= (int)((float)(plaquesHeight + 2) * (0.5f / plaqueScale));
        }
        return heightOffset;
    }

    private static void renderAllPlaques(class_10017 entityRenderState, MobPlaquesRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, int heightOffset) {
        Iterator<MobPlaqueRenderer> iterator = PLAQUE_RENDERERS.iterator();
        List<MutableInt> widths = MobPlaqueHandler.getPlaquesWidths(renderState);
        for (MutableInt width : widths) {
            int rowStart = -width.intValue() / 2;
            int maxRowHeight = 0;
            while (iterator.hasNext()) {
                MobPlaqueRenderer mobPlaqueRenderer = iterator.next();
                if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
                int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
                mobPlaqueRenderer.submit(rowStart + plaqueWidth / 2, heightOffset, poseStack, submitNodeCollector, entityRenderState, renderState);
                maxRowHeight = Math.max(mobPlaqueRenderer.getHeight(renderState), maxRowHeight);
                rowStart += (plaqueWidth += 2);
                if (width.addAndGet(-plaqueWidth) > 0) continue;
                break;
            }
            heightOffset += maxRowHeight + 2;
        }
    }

    private static float getPlaqueScale(double distanceToCameraSq) {
        float plaqueScale = (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueScale;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).scaleWithDistance) {
            double entityInteractionRange = class_310.method_1551().field_1724.method_55755();
            double scaleRatio = class_3532.method_15350((double)((distanceToCameraSq - Math.pow(entityInteractionRange / 2.0, 2.0)) / (Math.pow(entityInteractionRange * 2.0, 2.0) / 2.0)), (double)0.0, (double)2.0);
            plaqueScale *= (float)(1.0 + scaleRatio);
        }
        return plaqueScale;
    }

    private static List<MutableInt> getPlaquesWidths(MobPlaquesRenderState renderState) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        ArrayList widths = Lists.newArrayList();
        int index = -1;
        for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
            if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
            int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
            if (widths.isEmpty() || maxWidth < ((MutableInt)widths.get(index)).intValue() + 2 + plaqueWidth) {
                widths.add(new MutableInt(plaqueWidth));
                ++index;
                continue;
            }
            ((MutableInt)widths.get(index)).add(2 + plaqueWidth);
        }
        return widths;
    }

    private static int getPlaquesHeight(MobPlaquesRenderState renderState) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        int currentWidth = -1;
        int currentMaxHeight = 0;
        int totalHeight = -1;
        for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
            if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
            int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
            if (currentWidth == -1 || maxWidth < currentWidth + 2 + plaqueWidth) {
                currentWidth = plaqueWidth;
                currentMaxHeight = mobPlaqueRenderer.getHeight(renderState);
                totalHeight += mobPlaqueRenderer.getHeight(renderState) + (totalHeight == -1 ? 0 : 2);
                continue;
            }
            currentWidth += 2 + plaqueWidth;
            if (mobPlaqueRenderer.getHeight(renderState) <= currentMaxHeight) continue;
            totalHeight += mobPlaqueRenderer.getHeight(renderState) - currentMaxHeight;
            currentMaxHeight = mobPlaqueRenderer.getHeight(renderState);
        }
        return totalHeight;
    }
}

