/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.AirPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ArmorPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.HealthPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ToughnessPlaqueRenderer;
import fuzs.mobplaques.client.helper.EntityVisibilityHelper;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Quaternionfc;

public class MobPlaqueHandler {
    private static final ContextKey<MobPlaquesRenderState> RENDER_STATE_PROPERTY = new ContextKey(MobPlaques.id("render_state"));
    private static final int PLAQUE_HORIZONTAL_DISTANCE = 2;
    private static final int PLAQUE_VERTICAL_DISTANCE = 2;
    public static final List<MobPlaqueRenderer> PLAQUE_RENDERERS = List.of(new HealthPlaqueRenderer(), new AirPlaqueRenderer(), new ArmorPlaqueRenderer(), new ToughnessPlaqueRenderer());

    public static void onExtractRenderState(Entity entity, EntityRenderState entityRenderState, float partialTick) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && MobPlaqueHandler.canPlaqueRender(livingEntity = (LivingEntity)entity, partialTick)) {
            MobPlaquesRenderState renderState = new MobPlaquesRenderState();
            RenderStateExtraData.set((EntityRenderState)entityRenderState, RENDER_STATE_PROPERTY, (Object)renderState);
            for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
                mobPlaqueRenderer.extractRenderState(livingEntity, renderState, partialTick);
            }
            if (entityRenderState.nameTag == null) {
                entityRenderState.nameTag = CommonComponents.EMPTY;
                entityRenderState.nameTagAttachment = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getViewYRot(partialTick));
            }
        }
    }

    private static boolean canPlaqueRender(LivingEntity livingEntity, float partialTick) {
        Vec3 nameTagAttachment;
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return false;
        }
        if (livingEntity.isAlive() && ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).isEntityAllowed(livingEntity) && (nameTagAttachment = livingEntity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, livingEntity.getViewYRot(partialTick))) != null) {
            return EntityVisibilityHelper.isEntityVisible(livingEntity, partialTick, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntity);
        }
        return false;
    }

    public static EventResult onRenderNameTag(EntityRenderer<?, ?> entityRenderer, EntityRenderState entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (entityRenderState.nameTag != null && RenderStateExtraData.has((EntityRenderState)entityRenderState, RENDER_STATE_PROPERTY)) {
            poseStack.pushPose();
            Vec3 nameTagAttachment = entityRenderState.nameTagAttachment;
            if (nameTagAttachment != null) {
                poseStack.translate(nameTagAttachment.x, nameTagAttachment.y + 0.5, nameTagAttachment.z);
            }
            poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
            float plaqueScale = MobPlaqueHandler.getPlaqueScale(entityRenderState.distanceToCameraSq);
            poseStack.scale(0.025f * plaqueScale, -0.025f * plaqueScale, 0.025f * plaqueScale);
            MobPlaquesRenderState renderState = (MobPlaquesRenderState)RenderStateExtraData.get((EntityRenderState)entityRenderState, RENDER_STATE_PROPERTY);
            int heightOffset = MobPlaqueHandler.computeHeightOffset(renderState, entityRenderState.nameTag, plaqueScale);
            MobPlaqueHandler.renderAllPlaques(entityRenderState, renderState, poseStack, submitNodeCollector, cameraRenderState, heightOffset);
            poseStack.popPose();
            if (entityRenderState.nameTag == CommonComponents.EMPTY) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static int computeHeightOffset(MobPlaquesRenderState renderState, Component component, float plaqueScale) {
        int heightOffset = "deadmau5".equals(component.getString()) ? -13 : -3;
        heightOffset -= (int)((float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).offsetHeight * (0.5f / plaqueScale));
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBelowNameTag) {
            heightOffset += (int)(23.0f * (0.5f / plaqueScale));
        } else {
            int plaquesHeight = MobPlaqueHandler.getPlaquesHeight(renderState);
            heightOffset -= (int)((float)(plaquesHeight + 2) * (0.5f / plaqueScale));
        }
        return heightOffset;
    }

    private static void renderAllPlaques(EntityRenderState entityRenderState, MobPlaquesRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, int heightOffset) {
        Iterator<MobPlaqueRenderer> iterator = PLAQUE_RENDERERS.iterator();
        List<MutableInt> widths = MobPlaqueHandler.getPlaquesWidths(renderState);
        for (MutableInt width : widths) {
            int rowStart = -width.intValue() / 2;
            int maxRowHeight = 0;
            while (iterator.hasNext()) {
                MobPlaqueRenderer mobPlaqueRenderer = iterator.next();
                if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
                int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
                mobPlaqueRenderer.submit(rowStart + plaqueWidth / 2, heightOffset, poseStack, submitNodeCollector, entityRenderState, renderState);
                maxRowHeight = Math.max(mobPlaqueRenderer.getHeight(renderState), maxRowHeight);
                rowStart += (plaqueWidth += 2);
                if (width.addAndGet(-plaqueWidth) > 0) continue;
                break;
            }
            heightOffset += maxRowHeight + 2;
        }
    }

    private static float getPlaqueScale(double distanceToCameraSq) {
        float plaqueScale = (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueScale;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).scaleWithDistance) {
            double entityInteractionRange = Minecraft.getInstance().player.entityInteractionRange();
            double scaleRatio = Mth.clamp((double)((distanceToCameraSq - Math.pow(entityInteractionRange / 2.0, 2.0)) / (Math.pow(entityInteractionRange * 2.0, 2.0) / 2.0)), (double)0.0, (double)2.0);
            plaqueScale *= (float)(1.0 + scaleRatio);
        }
        return plaqueScale;
    }

    private static List<MutableInt> getPlaquesWidths(MobPlaquesRenderState renderState) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        ArrayList widths = Lists.newArrayList();
        int index = -1;
        for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
            if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
            int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
            if (widths.isEmpty() || maxWidth < ((MutableInt)widths.get(index)).intValue() + 2 + plaqueWidth) {
                widths.add(new MutableInt(plaqueWidth));
                ++index;
                continue;
            }
            ((MutableInt)widths.get(index)).add(2 + plaqueWidth);
        }
        return widths;
    }

    private static int getPlaquesHeight(MobPlaquesRenderState renderState) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        int currentWidth = -1;
        int currentMaxHeight = 0;
        int totalHeight = -1;
        for (MobPlaqueRenderer mobPlaqueRenderer : PLAQUE_RENDERERS) {
            if (!mobPlaqueRenderer.isRenderingAllowed(renderState)) continue;
            int plaqueWidth = mobPlaqueRenderer.getWidth(renderState);
            if (currentWidth == -1 || maxWidth < currentWidth + 2 + plaqueWidth) {
                currentWidth = plaqueWidth;
                currentMaxHeight = mobPlaqueRenderer.getHeight(renderState);
                totalHeight += mobPlaqueRenderer.getHeight(renderState) + (totalHeight == -1 ? 0 : 2);
                continue;
            }
            currentWidth += 2 + plaqueWidth;
            if (mobPlaqueRenderer.getHeight(renderState) <= currentMaxHeight) continue;
            totalHeight += mobPlaqueRenderer.getHeight(renderState) - currentMaxHeight;
            currentMaxHeight = mobPlaqueRenderer.getHeight(renderState);
        }
        return totalHeight;
    }
}

