/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.config.ClientConfig;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PickEntityHandler {
    @Nullable
    private static UUID crosshairPickEntity;
    private static int pickDelay;

    @Nullable
    public static UUID getCrosshairPickEntity() {
        return crosshairPickEntity;
    }

    public static void onStartClientTick(Minecraft minecraft) {
        if (minecraft.level != null && !minecraft.isPaused() && pickDelay > 0) {
            --pickDelay;
        }
    }

    public static void onBeforeGameRender(Minecraft minecraft, GameRenderer gameRenderer, DeltaTracker deltaTracker) {
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return;
        }
        PickEntityHandler.pick(minecraft, gameRenderer, deltaTracker.getGameTimeDeltaPartialTick(true));
    }

    private static void pick(Minecraft minecraft, GameRenderer gameRenderer, float partialTick) {
        Entity cameraEntity = minecraft.getCameraEntity();
        if (cameraEntity != null && minecraft.level != null && minecraft.player != null) {
            HitResult hitResult;
            Profiler.get().push("pick");
            double blockInteractionRange = minecraft.player.blockInteractionRange();
            double entityInteractionRange = minecraft.player.entityInteractionRange();
            int interactionRange = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntityInteractionRange;
            if (interactionRange != -1) {
                blockInteractionRange = entityInteractionRange = (double)interactionRange;
            }
            if ((hitResult = PickEntityHandler.pick(cameraEntity, blockInteractionRange, entityInteractionRange, partialTick)) instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                Entity entity = entityHitResult.getEntity();
                if (entity instanceof EnderDragonPart) {
                    EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
                    entity = enderDragonPart.parentMob;
                }
                crosshairPickEntity = entity.getUUID();
                pickDelay = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntityDelay * 20;
            } else if (pickDelay == 0) {
                crosshairPickEntity = null;
            }
            Profiler.get().pop();
        }
    }

    private static HitResult pick(Entity entity, double blockInteractionRange, double entityInteractionRange, float partialTick) {
        AABB aABB;
        double interactionRange = Math.max(blockInteractionRange, entityInteractionRange);
        double interactionRangeSqr = Mth.square((double)interactionRange);
        Vec3 eyePosition = entity.getEyePosition(partialTick);
        HitResult hitResult = PickEntityHandler.pick(entity, interactionRange, partialTick, false);
        double distanceToHitResult = hitResult.getLocation().distanceToSqr(eyePosition);
        if (hitResult.getType() != HitResult.Type.MISS) {
            interactionRangeSqr = distanceToHitResult;
            interactionRange = Math.sqrt(distanceToHitResult);
        }
        Vec3 viewVector = entity.getViewVector(partialTick);
        Vec3 vec3 = eyePosition.add(viewVector.x * interactionRange, viewVector.y * interactionRange, viewVector.z * interactionRange);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePosition, (Vec3)vec3, (AABB)(aABB = entity.getBoundingBox().expandTowards(viewVector.scale(interactionRange)).inflate(1.0, 1.0, 1.0)), entityX -> (entityX instanceof LivingEntity || entityX instanceof EnderDragonPart) && !entityX.isSpectator() && entityX.isPickable(), (double)interactionRangeSqr);
        return entityHitResult != null && entityHitResult.getLocation().distanceToSqr(eyePosition) < distanceToHitResult ? GameRenderer.filterHitResult((HitResult)entityHitResult, (Vec3)eyePosition, (double)entityInteractionRange) : GameRenderer.filterHitResult((HitResult)hitResult, (Vec3)eyePosition, (double)blockInteractionRange);
    }

    private static HitResult pick(Entity entity, double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3 eyePosition = entity.getEyePosition(partialTicks);
        Vec3 viewVector = entity.getViewVector(partialTicks);
        Vec3 vec3 = eyePosition.add(viewVector.x * hitDistance, viewVector.y * hitDistance, viewVector.z * hitDistance);
        return entity.level().clip(new ClipContext(eyePosition, vec3, ClipContext.Block.VISUAL, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }
}

