/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.TransitionPlaqueRenderer;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HealthPlaqueRenderer
extends TransitionPlaqueRenderer {
    private static final ResourceLocation HEART_VEHICLE_FULL_SPRITE = MobPlaques.id("hud/heart/vehicle_full");

    public HealthPlaqueRenderer() {
        super(2011392, 15541005);
    }

    @Override
    public int getValue(MobPlaquesRenderState renderState) {
        return Math.min(renderState.health, renderState.maxHealth) + renderState.absorption;
    }

    @Override
    public int getMaxValue(MobPlaquesRenderState renderState) {
        return renderState.maxHealth + renderState.absorption;
    }

    @Override
    protected ResourceLocation getSprite(MobPlaquesRenderState renderState) {
        return renderState.sprite;
    }

    @Override
    public void extractRenderState(LivingEntity livingEntity, MobPlaquesRenderState renderState, float partialTick) {
        super.extractRenderState(livingEntity, renderState, partialTick);
        renderState.health = Mth.ceil((float)livingEntity.getHealth());
        renderState.maxHealth = Mth.ceil((float)livingEntity.getMaxHealth());
        renderState.absorption = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        renderState.sprite = this.getSprite(livingEntity);
    }

    @Override
    public String getName() {
        return "Health";
    }

    private ResourceLocation getSprite(LivingEntity livingEntity) {
        return HealthPlaqueRenderer.isMount(livingEntity) ? HEART_VEHICLE_FULL_SPRITE : HealthPlaqueRenderer.getSprite(HealthPlaqueRenderer.forEntity(livingEntity), livingEntity);
    }

    public static ResourceLocation getSprite(Gui.HeartType heartType) {
        return HealthPlaqueRenderer.getSprite(heartType, null);
    }

    private static ResourceLocation getSprite(Gui.HeartType heartType, @Nullable LivingEntity livingEntity) {
        ResourceLocation resourceLocation = heartType.getSprite(HealthPlaqueRenderer.isHardcore(livingEntity), false, false);
        return MobPlaques.id(resourceLocation.getPath());
    }

    private static boolean isHardcore(@Nullable LivingEntity livingEntity) {
        Player player;
        return livingEntity instanceof Player && (player = (Player)livingEntity).level().getLevelData().isHardcore();
    }

    private static boolean isMount(LivingEntity livingEntity) {
        Mob mob;
        return livingEntity instanceof Mob && (mob = (Mob)livingEntity).isSaddled();
    }

    private static Gui.HeartType forEntity(LivingEntity livingEntity) {
        if (livingEntity.hasEffect(MobEffects.POISON)) {
            return Gui.HeartType.POISIONED;
        }
        if (livingEntity.hasEffect(MobEffects.WITHER)) {
            return Gui.HeartType.WITHERED;
        }
        if (livingEntity.isFullyFrozen()) {
            return Gui.HeartType.FROZEN;
        }
        if (livingEntity.getAbsorptionAmount() > 0.0f) {
            return Gui.HeartType.ABSORBING;
        }
        return Gui.HeartType.NORMAL;
    }
}

