/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.renderer.ModRenderType;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.joml.Matrix4f;

public abstract class MobPlaqueRenderer {
    protected static final int FULL_BRIGHTNESS_PACKED_LIGHT = 0xF000F0;
    protected static final int BACKGROUND_BORDER_SIZE = 1;
    protected boolean allowRendering;

    public boolean isRenderingAllowed(MobPlaquesRenderState renderState) {
        return this.allowRendering && this.getValue(renderState) > 0;
    }

    public int getWidth(MobPlaquesRenderState renderState) {
        return Minecraft.getInstance().font.width((FormattedText)this.getComponent(renderState)) + 2;
    }

    public int getHeight(MobPlaquesRenderState renderState) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9 + 2;
    }

    public abstract int getValue(MobPlaquesRenderState var1);

    protected MutableComponent getTextComponent(MobPlaquesRenderState renderState) {
        return Component.literal((String)(this.getValue(renderState) + "x"));
    }

    public final Component getComponent(MobPlaquesRenderState renderState) {
        return Component.empty().append((Component)this.getTextComponent(renderState).withColor(this.getColor(renderState))).append((Component)Component.object((ObjectInfo)new AtlasSprite(AtlasIds.GUI, this.getSprite(renderState))));
    }

    protected int getColor(MobPlaquesRenderState renderState) {
        return ARGB.transparent((int)-1);
    }

    public void submit(int posX, int posY, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, EntityRenderState entityRenderState, MobPlaquesRenderState renderState) {
        this.submitTextBackground(poseStack, posX, posY, submitNodeCollector, entityRenderState, renderState);
        this.submitTextComponent(poseStack, posX, posY, submitNodeCollector, entityRenderState, renderState);
    }

    private void submitTextBackground(PoseStack poseStack, int posX, int posY, SubmitNodeCollector submitNodeCollector, EntityRenderState entityRenderState, MobPlaquesRenderState renderState) {
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBackground) {
            int backgroundColor = Minecraft.getInstance().options.getBackgroundColor(0.25f);
            RenderType renderType = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls ? RenderType.textBackgroundSeeThrough() : ModRenderType.textBackground();
            submitNodeCollector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
                Matrix4f matrix4f = pose.pose();
                int minX = posX - this.getWidth(renderState) / 2;
                int minY = posY;
                int maxX = posX + this.getWidth(renderState) / 2;
                int maxY = posY + this.getHeight(renderState);
                int packedLight = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : entityRenderState.lightCoords;
                vertexConsumer.addVertex(matrix4f, (float)minX, (float)minY, 0.0f).setColor(backgroundColor).setLight(packedLight);
                vertexConsumer.addVertex(matrix4f, (float)minX, (float)maxY, 0.0f).setColor(backgroundColor).setLight(packedLight);
                vertexConsumer.addVertex(matrix4f, (float)maxX, (float)maxY, 0.0f).setColor(backgroundColor).setLight(packedLight);
                vertexConsumer.addVertex(matrix4f, (float)maxX, (float)minY, 0.0f).setColor(backgroundColor).setLight(packedLight);
            });
        }
    }

    private void submitTextComponent(PoseStack poseStack, int posX, int posY, SubmitNodeCollector submitNodeCollector, EntityRenderState entityRenderState, MobPlaquesRenderState renderState) {
        int packedLight;
        FormattedCharSequence formattedCharSequence = this.getComponent(renderState).getVisualOrderText();
        int x = posX - this.getWidth(renderState) / 2 + 1;
        int y = posY + 1 + 1;
        int n = packedLight = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : entityRenderState.lightCoords;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            submitNodeCollector.order(1).submitText(poseStack, (float)x, (float)y, formattedCharSequence, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderTextShadow, Font.DisplayMode.SEE_THROUGH, packedLight, ARGB.color((int)(((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 128 : 32), (int)-1), 0, entityRenderState.outlineColor);
        }
        submitNodeCollector.order(1).submitText(poseStack, (float)x, (float)y, formattedCharSequence, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderTextShadow, Font.DisplayMode.NORMAL, packedLight, -1, 0, entityRenderState.outlineColor);
    }

    protected abstract ResourceLocation getSprite(MobPlaquesRenderState var1);

    public void setupConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Allow for rendering this type of plaque.").define("allow_rendering", true), v -> {
            this.allowRendering = v;
        });
    }

    public void extractRenderState(LivingEntity livingEntity, MobPlaquesRenderState renderState, float partialTick) {
    }

    public abstract String getName();
}

