/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.renderer.entity.state.MobPlaquesRenderState;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class TransitionPlaqueRenderer
extends MobPlaqueRenderer {
    private final int defaultHighColor;
    private final int defaultLowColor;
    private boolean shiftColors;
    private PlaqueValue plaqueValue;

    protected TransitionPlaqueRenderer(int defaultHighColor, int defaultLowColor) {
        this.defaultHighColor = defaultHighColor;
        this.defaultLowColor = defaultLowColor;
    }

    public abstract int getMaxValue(MobPlaquesRenderState var1);

    protected boolean isBelowMaxValue(MobPlaquesRenderState renderState) {
        return this.getValue(renderState) < this.getMaxValue(renderState);
    }

    @Override
    protected MutableComponent getTextComponent(MobPlaquesRenderState renderState) {
        return switch (this.plaqueValue.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> super.getTextComponent(renderState);
            case 1 -> Component.literal((String)(this.getValue(renderState) + "/" + this.getMaxValue(renderState)));
            case 2 -> Component.literal((String)((int)(this.getValuePercentage(renderState) * 100.0f) + "%"));
        };
    }

    @Override
    protected int getColor(MobPlaquesRenderState renderState) {
        if (!this.shiftColors) {
            return super.getColor(renderState);
        }
        float transition = this.getValuePercentage(renderState);
        return TransitionPlaqueRenderer.packTransitionedColor(this.defaultHighColor, this.defaultLowColor, transition);
    }

    private float getValuePercentage(MobPlaquesRenderState renderState) {
        return Mth.clamp((float)((float)this.getValue(renderState) / (float)this.getMaxValue(renderState)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setupConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        super.setupConfig(builder, callback);
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Transition text colors depending on current percentage.").define("shift_colors", false), v -> {
            this.shiftColors = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Show current amount either as percentage or as absolute value.").defineEnum("plaque_value", (Enum)PlaqueValue.RELATIVE), v -> {
            this.plaqueValue = v;
        });
    }

    public static int packTransitionedColor(int startColor, int endColor, float transition) {
        int startR = ARGB.red((int)startColor);
        int startG = ARGB.green((int)startColor);
        int startB = ARGB.blue((int)startColor);
        int endR = ARGB.red((int)endColor);
        int endG = ARGB.green((int)endColor);
        int endB = ARGB.blue((int)endColor);
        int colorR = endR + (int)((float)(startR - endR) * transition);
        int colorG = endG + (int)((float)(startG - endG) * transition);
        int colorB = endB + (int)((float)(startB - endB) * transition);
        return ARGB.color((int)0, (int)colorR, (int)colorG, (int)colorB);
    }

    private static enum PlaqueValue {
        ABSOLUTE,
        ABSOLUTE_WITH_MAX,
        RELATIVE;

    }
}

