/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.helper;

import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.handler.PickEntityHandler;
import fuzs.mobplaques.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class EntityVisibilityHelper {
    public static boolean isEntityVisible(LivingEntity livingEntity, float partialTick, boolean mustBePicked) {
        Minecraft minecraft = Minecraft.getInstance();
        return EntityVisibilityHelper.isEntityVisible((Level)minecraft.level, livingEntity, (Player)minecraft.player, partialTick, minecraft.getEntityRenderDispatcher(), mustBePicked);
    }

    public static boolean isEntityVisible(Level level, LivingEntity livingEntity, Player player, float partialTicks, EntityRenderDispatcher entityRenderDispatcher, boolean mustBePicked) {
        if (mustBePicked && !livingEntity.getUUID().equals(PickEntityHandler.getCrosshairPickEntity())) {
            return false;
        }
        if (!EntityVisibilityHelper.shouldShowName(livingEntity)) {
            return false;
        }
        return entityRenderDispatcher.distanceToSqr((Entity)livingEntity) < (double)EntityVisibilityHelper.getMaxRenderDistanceSqr(level, livingEntity, player, partialTicks);
    }

    private static boolean shouldShowName(LivingEntity entity) {
        PlayerTeam entityTeam;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        boolean isVisible = EntityVisibilityHelper.isVisibleToPlayer(entity, (Player)player);
        if (entity != player && (entityTeam = entity.getTeam()) != null) {
            PlayerTeam playerTeam = player.getTeam();
            return switch (entityTeam.getNameTagVisibility()) {
                default -> throw new MatchException(null, null);
                case Team.Visibility.ALWAYS -> isVisible;
                case Team.Visibility.NEVER -> false;
                case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                    if (playerTeam == null) {
                        yield isVisible;
                    }
                    if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || isVisible)) {
                        yield true;
                    }
                    yield false;
                }
                case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? isVisible : !entityTeam.isAlliedTo((Team)playerTeam) && isVisible;
            };
        }
        return Minecraft.renderNames() && entity != minecraft.getCameraEntity() && isVisible && !entity.isVehicle();
    }

    private static boolean isVisibleToPlayer(LivingEntity entity, Player player) {
        if (entity.isSpectator()) {
            return false;
        }
        if (entity.isInvisibleTo(player)) {
            Creeper creeper;
            if (entity.isOnFire() || entity.isCurrentlyGlowing()) {
                return true;
            }
            if (entity instanceof Creeper && (creeper = (Creeper)entity).isPowered()) {
                return true;
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
                ItemStack itemStack = entity.getItemBySlot(equipmentSlot);
                if (itemStack.isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int getMaxRenderDistanceSqr(Level level, LivingEntity livingEntity, Player player, float partialTicks) {
        int maxRenderDistance = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxRenderDistance;
        if (livingEntity.isDiscrete()) {
            maxRenderDistance /= 2;
        }
        if (EntityVisibilityHelper.pickVisual(level, livingEntity, player, partialTicks).getType() != HitResult.Type.MISS) {
            maxRenderDistance /= 4;
        }
        return maxRenderDistance * maxRenderDistance;
    }

    private static HitResult pickVisual(Level level, LivingEntity livingEntity, Player player, float partialTicks) {
        Vec3 playerEyePosition = player.getEyePosition(partialTicks);
        Vec3 entityEyePosition = livingEntity.getEyePosition(partialTicks);
        return level.clip(new ClipContext(playerEyePosition, entityEyePosition, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
    }
}

