/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.helper;

import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.handler.PickEntityHandler;
import fuzs.mobplaques.config.ClientConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_746;
import net.minecraft.class_898;

public class EntityVisibilityHelper {
    public static boolean isEntityVisible(class_1309 livingEntity, float partialTick, boolean mustBePicked) {
        class_310 minecraft = class_310.method_1551();
        return EntityVisibilityHelper.isEntityVisible((class_1937)minecraft.field_1687, livingEntity, (class_1657)minecraft.field_1724, partialTick, minecraft.method_1561(), mustBePicked);
    }

    public static boolean isEntityVisible(class_1937 level, class_1309 livingEntity, class_1657 player, float partialTicks, class_898 entityRenderDispatcher, boolean mustBePicked) {
        if (mustBePicked && !livingEntity.method_5667().equals(PickEntityHandler.getCrosshairPickEntity())) {
            return false;
        }
        if (!EntityVisibilityHelper.shouldShowName(livingEntity)) {
            return false;
        }
        return entityRenderDispatcher.method_23168((class_1297)livingEntity) < (double)EntityVisibilityHelper.getMaxRenderDistanceSqr(level, livingEntity, player, partialTicks);
    }

    private static boolean shouldShowName(class_1309 entity) {
        class_268 entityTeam;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        boolean isVisible = EntityVisibilityHelper.isVisibleToPlayer(entity, (class_1657)player);
        if (entity != player && (entityTeam = entity.method_5781()) != null) {
            class_268 playerTeam = player.method_5781();
            return switch (entityTeam.method_1201()) {
                default -> throw new MatchException(null, null);
                case class_270.class_272.field_1442 -> isVisible;
                case class_270.class_272.field_1443 -> false;
                case class_270.class_272.field_1444 -> {
                    if (playerTeam == null) {
                        yield isVisible;
                    }
                    if (entityTeam.method_1206((class_270)playerTeam) && (entityTeam.method_1199() || isVisible)) {
                        yield true;
                    }
                    yield false;
                }
                case class_270.class_272.field_1446 -> playerTeam == null ? isVisible : !entityTeam.method_1206((class_270)playerTeam) && isVisible;
            };
        }
        return class_310.method_1498() && entity != minecraft.method_1560() && isVisible && !entity.method_5782();
    }

    private static boolean isVisibleToPlayer(class_1309 entity, class_1657 player) {
        if (entity.method_7325()) {
            return false;
        }
        if (entity.method_5756(player)) {
            class_1548 creeper;
            if (entity.method_5809() || entity.method_5851()) {
                return true;
            }
            if (entity instanceof class_1548 && (creeper = (class_1548)entity).method_61492()) {
                return true;
            }
            for (class_1304 equipmentSlot : class_1304.field_54086) {
                class_1799 itemStack = entity.method_6118(equipmentSlot);
                if (itemStack.method_7960()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int getMaxRenderDistanceSqr(class_1937 level, class_1309 livingEntity, class_1657 player, float partialTicks) {
        int maxRenderDistance = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxRenderDistance;
        if (livingEntity.method_21751()) {
            maxRenderDistance /= 2;
        }
        if (EntityVisibilityHelper.pickVisual(level, livingEntity, player, partialTicks).method_17783() != class_239.class_240.field_1333) {
            maxRenderDistance /= 4;
        }
        return maxRenderDistance * maxRenderDistance;
    }

    private static class_239 pickVisual(class_1937 level, class_1309 livingEntity, class_1657 player, float partialTicks) {
        class_243 playerEyePosition = player.method_5836(partialTicks);
        class_243 entityEyePosition = livingEntity.method_5836(partialTicks);
        return level.method_17742(new class_3959(playerEyePosition, entityEyePosition, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)player));
    }
}

