/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.config;

import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.handler.MobPlaqueHandler;
import fuzs.mobplaques.config.MobSelector;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig
implements ConfigCore {
    private static final String KEY_GENERAL_CATEGORY = "general";
    public ModConfigSpec.ConfigValue<Boolean> allowRendering;
    @Config(category={"general"}, description={"Hide all plaques when mob has full health."})
    public boolean hideAtFullHealth = false;
    @Config(category={"general"}, description={"Show plaques for the entity picked by the crosshair only."})
    public boolean pickedEntity = false;
    @Config(category={"general"}, description={"The raytrace range for finding a picked entity.", "Setting this to -1 will make it use the player entity interaction range, which is 3 in survival."})
    @Config.IntRange(min=-1, max=128)
    public int pickedEntityInteractionRange = -1;
    @Config(category={"general"}, description={"Coyote time in seconds after which a no longer picked entity will still show the plaques.", "Set to -1 to keep the old entity until a new one is picked by the crosshair."})
    @Config.IntRange(min=-1)
    public int pickedEntityDelay = 2;
    @Config(category={"general"}, description={"Custom scale for rendering plaques."})
    @Config.DoubleRange(min=0.05, max=2.0)
    public double plaqueScale = 0.5;
    @Config(category={"general"}, description={"Amount of pixels a row of plaques may take up, when exceeding this value a new row will be started."})
    @Config.IntRange(min=0)
    public int maxPlaqueRowWidth = 108;
    @Config(category={"general"}, description={"Render mob plaques below the mob's name tag instead of above."})
    public boolean renderBelowNameTag = false;
    @Config(category={"general"}, description={"Show a black background box behind plaques. Disabled with shaders when causing issues."})
    public boolean renderBackground = true;
    @Config(category={"general"}, description={"Show a dark text shadow behind plaque text."})
    public boolean renderTextShadow = false;
    @Config(category={"general"}, description={"Always render plaques with full brightness to be most visible, ignoring local lighting conditions."})
    public boolean fullBrightness = true;
    @Config(category={"general"}, description={"Height offset from default position."})
    public int offsetHeight = 0;
    @Config(category={"general"}, description={"Distance to the mob at which plaques will still be visible. The distance is halved when the mob is crouching."})
    @Config.IntRange(min=0)
    public int maxRenderDistance = 96;
    @Config(category={"general"}, description={"Show plaques from mobs obstructed by walls the player cannot see through, similar to the nameplates of other players."})
    public boolean behindWalls = true;
    @Config(category={"general"}, description={"Dynamically increase plaque size the further away the camera is to simplify readability."})
    public boolean scaleWithDistance = true;
    @Config(category={"general"}, name="no_plaque_mobs", description={"Entities blacklisted from showing any plaques.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> noPlaqueMobsRaw = KeyedValueProvider.asString((class_5321)class_7924.field_41266, (Object[])new class_1299[]{class_1299.field_6131});
    @Config(category={"general"}, description={"Selectors for choosing mobs to render plaques for."})
    public final MobSelectorsConfig mobSelectors = new MobSelectorsConfig();
    public ConfigDataSet<class_1299<?>> noPlaqueMobs;

    public void addToBuilder(ModConfigSpec.Builder builder, ValueCallback callback) {
        this.allowRendering = builder.comment("Are mob plaques enabled, toggleable in-game via the dedicated keybinding.").define("allow_rendering", true);
        for (MobPlaqueRenderer mobPlaqueRenderer : MobPlaqueHandler.PLAQUE_RENDERERS) {
            builder.push(mobPlaqueRenderer.getName().toLowerCase(Locale.ROOT));
            mobPlaqueRenderer.setupConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        this.noPlaqueMobs = ConfigDataSet.from((class_5321)class_7924.field_41266, this.noPlaqueMobsRaw, (Class[])new Class[0]);
    }

    public boolean isEntityAllowed(class_1309 livingEntity) {
        if (this.noPlaqueMobs.contains((Object)livingEntity.method_5864())) {
            return false;
        }
        if (this.hideAtFullHealth && livingEntity.method_6032() >= livingEntity.method_6063()) {
            return false;
        }
        for (MobSelector mobSelector : MobSelector.VALUES) {
            if (!mobSelector.isSettingEnabled(this.mobSelectors) || !mobSelector.appliesToEntity(livingEntity)) continue;
            return true;
        }
        return false;
    }

    public static class MobSelectorsConfig
    implements ConfigCore {
        @Config(description={"Show plaques on all mobs."})
        public boolean allMobs = true;
        @Config(description={"Show plaques on tamed animals."})
        public boolean tamedAnimals = true;
        @Config(description={"Show plaques on tamed animals owned by you."})
        public boolean ownedAnimals = true;
        @Config(description={"Show plaques on players."})
        public boolean players = true;
        @Config(description={"Show plaques on monsters."})
        public boolean monsters = true;
        @Config(description={"Show plaques on bosses."})
        public boolean bosses = true;
        @Config(description={"Show plaques on mobs that can equipt a saddle."})
        public boolean mounts = true;
    }
}

