/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sakuraryoko.corelib.api.commands.IServerCommand;
import com.sakuraryoko.phantom_spawning.impl.PhantomSpawningMod;
import com.sakuraryoko.phantom_spawning.impl.commands.PermsWrap;
import com.sakuraryoko.phantom_spawning.impl.config.ConfigWrap;
import com.sakuraryoko.phantom_spawning.impl.modinit.InitWrap;
import com.sakuraryoko.phantom_spawning.impl.player.PlayerManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PhantomSpawningCommand
implements IServerCommand {
    private static final PhantomSpawningCommand INSTANCE = new PhantomSpawningCommand();

    public static PhantomSpawningCommand getInstance() {
        return INSTANCE;
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.getName()).requires(PermsWrap.check(this.getNode() + ".about", ConfigWrap.mainOpt().permission_level))).executes(this::about)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"true_false", (ArgumentType)BoolArgumentType.bool()).requires(PermsWrap.check(this.getNode() + ".true_false", ConfigWrap.mainOpt().permission_level))).executes(ctx -> this.toggle((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"true_false")))));
    }

    public String getName() {
        return "phantomspawning";
    }

    public String getModId() {
        return "phantom-spawning";
    }

    private int about(CommandContext<class_2168> ctx) {
        class_2561 text = InitWrap.text().formatText("\u00a77Please use \u00a7b/" + this.getName() + " <true|false>\u00a77 --\n\u00a77To Enable or disable Phantoms from Spawning.\n\u00a77This setting is Per-User.\u00a7r");
        ((class_2168)ctx.getSource()).method_9226(text, false);
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            boolean status = PlayerManager.getInstance().getPhantomStatus(player.method_7334());
            if (InitWrap.debug()) {
                PhantomSpawningMod.LOGGER.warn("CMD:about: from [{}]", (Object)player.method_5477().getString());
            }
            class_2561 text2 = InitWrap.text().formatText("\u00a7eCurrent status: " + (status ? "\u00a7cSpawning Enabled" : "\u00a7aSpawning Disabled") + "\u00a7r");
            ((class_2168)ctx.getSource()).method_9226(text2, false);
        }
        catch (CommandSyntaxException err) {
            PhantomSpawningMod.LOGGER.warn("CMD:about: Syntax Error; {}", (Object)err.getLocalizedMessage());
            return 0;
        }
        return 1;
    }

    private int toggle(CommandContext<class_2168> ctx, boolean toggle) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            PlayerManager.getInstance().setPhantomStatus(player.method_7334(), toggle);
            class_2561 text = toggle ? InitWrap.text().formatText("\u00a7cEnabled Phantom spawning.\u00a7r") : InitWrap.text().formatText("\u00a7aDisabled Phantoms from spawning.\u00a7r");
            ((class_2168)ctx.getSource()).method_9226(text, false);
            if (toggle) {
                PhantomSpawningMod.LOGGER.info("Player: '{}' has enabled Phantom spawns.", (Object)player.method_5477().getString());
            } else {
                PhantomSpawningMod.LOGGER.info("Player: '{}' has disabled Phantom spawns.", (Object)player.method_5477().getString());
            }
        }
        catch (CommandSyntaxException err) {
            PhantomSpawningMod.LOGGER.warn("CMD:toggle: Syntax Error; {}", (Object)err.getLocalizedMessage());
            return 0;
        }
        return 1;
    }
}

