/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.player;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.phantom_spawning.impl.config.ConfigWrap;
import com.sakuraryoko.phantom_spawning.impl.config.data.options.PlayerOptions;
import com.sakuraryoko.phantom_spawning.impl.player.ProfileWrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PlayerManager {
    private static final PlayerManager INSTANCE = new PlayerManager();
    private final HashMap<UUID, Boolean> playerMap = new HashMap();

    public static PlayerManager getInstance() {
        return INSTANCE;
    }

    private PlayerManager() {
    }

    public void syncProfile(GameProfile profile) {
        List<PlayerOptions> config = ConfigWrap.players();
        UUID uuid = ProfileWrap.id(profile);
        for (PlayerOptions opt : config) {
            if (!opt.uuid.equals(uuid)) continue;
            this.addOrUpdateProfile(profile, opt.phantomSpawning);
            return;
        }
        this.addConfig(profile);
    }

    private void addOrUpdateProfile(GameProfile profile, boolean toggle) {
        UUID uuid = ProfileWrap.id(profile);
        if (this.playerMap.containsKey(uuid) && this.playerMap.get(uuid) != toggle) {
            this.playerMap.remove(uuid);
            this.playerMap.put(uuid, toggle);
        } else if (!this.playerMap.containsKey(uuid)) {
            this.playerMap.put(uuid, toggle);
        }
    }

    private void addConfig(GameProfile profile) {
        ArrayList<PlayerOptions> config = new ArrayList<PlayerOptions>(ConfigWrap.players());
        boolean exists = false;
        for (PlayerOptions entry : config) {
            if (!entry.uuid.equals(ProfileWrap.id(profile))) continue;
            exists = true;
        }
        if (!exists) {
            ConfigWrap.players().add(PlayerOptions.fromProfile(profile, true));
        }
    }

    private void setConfig(GameProfile profile, boolean toggle) {
        ArrayList<PlayerOptions> config = new ArrayList<PlayerOptions>(ConfigWrap.players());
        boolean dirty = false;
        for (PlayerOptions entry : config) {
            if (!entry.uuid.equals(ProfileWrap.id(profile))) continue;
            entry.phantomSpawning = toggle;
            dirty = true;
        }
        if (dirty) {
            ConfigWrap.players().clear();
            ConfigWrap.players().addAll(config);
        }
    }

    public boolean getPhantomStatus(@NotNull GameProfile profile) {
        UUID uuid = ProfileWrap.id(profile);
        if (this.playerMap.containsKey(uuid)) {
            return this.playerMap.get(uuid);
        }
        this.addOrUpdateProfile(profile, true);
        this.addConfig(profile);
        return true;
    }

    public void setPhantomStatus(@NotNull GameProfile profile, boolean toggle) {
        this.addOrUpdateProfile(profile, toggle);
        this.setConfig(profile, toggle);
    }
}

