/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sakuraryoko.corelib.api.commands.IServerCommand;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.modinit.ModInitData;
import com.sakuraryoko.corelib.impl.config.ConfigManager;
import com.sakuraryoko.phantom_spawning.impl.PhantomSpawningMod;
import com.sakuraryoko.phantom_spawning.impl.commands.PermsWrap;
import com.sakuraryoko.phantom_spawning.impl.config.ConfigWrap;
import com.sakuraryoko.phantom_spawning.impl.config.PhantomSpawningConfigHandler;
import com.sakuraryoko.phantom_spawning.impl.modinit.InitWrap;
import com.sakuraryoko.phantom_spawning.impl.modinit.PhantomSpawningInit;
import com.sakuraryoko.phantom_spawning.impl.player.PlayerManager;
import com.sakuraryoko.phantom_spawning.impl.player.ProfileWrap;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PhantomSpawningAdminCommand
implements IServerCommand {
    private static final PhantomSpawningAdminCommand INSTANCE = new PhantomSpawningAdminCommand();

    public static PhantomSpawningAdminCommand getInstance() {
        return INSTANCE;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.getName()).requires(PermsWrap.check(this.getNode(), ConfigWrap.mainOpt().permission_level_admin))).executes(this::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(PermsWrap.check(this.getNode() + ".reload", ConfigWrap.mainOpt().permission_level_admin))).executes(this::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(PermsWrap.check(this.getNode() + ".save", ConfigWrap.mainOpt().permission_level_admin))).executes(this::save))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(PermsWrap.check(this.getNode() + ".info", ConfigWrap.mainOpt().permission_level_admin))).executes(this::infoPlayer)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.infoPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"at-risk").requires(PermsWrap.check(this.getNode() + ".at-risk", ConfigWrap.mainOpt().permission_level_admin))).executes(this::displayAtRisk))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").requires(PermsWrap.check(this.getNode() + ".toggle", ConfigWrap.mainOpt().permission_level_admin))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.togglePlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.togglePlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), BoolArgumentType.getBool((CommandContext)ctx, (String)"toggle"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(PermsWrap.check(this.getNode() + ".debug", ConfigWrap.mainOpt().permission_level_admin))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.debugPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.debugPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), BoolArgumentType.getBool((CommandContext)ctx, (String)"toggle"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle-all").requires(PermsWrap.check(this.getNode() + ".toggle-all", ConfigWrap.mainOpt().permission_level_admin))).executes(this::toggleAll)).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.toggleAll((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"toggle")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug-all").requires(PermsWrap.check(this.getNode() + ".debug-all", ConfigWrap.mainOpt().permission_level_admin))).executes(this::debugAll)).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.debugAll((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"toggle"))))));
    }

    public String getName() {
        return "phantomspawning-admin";
    }

    public String getModId() {
        return "phantom-spawning";
    }

    private int about(CommandContext<class_2168> ctx) {
        List info = PhantomSpawningInit.getInstance().getVanillaFormatted(ModInitData.ALL_INFO);
        class_5250 text = class_2561.method_43470((String)"");
        for (class_2561 entry : info) {
            text.method_10852(entry).method_27693("\n");
        }
        text.method_27693(" - \u00a77Global Debug status: ").method_10852(this.createDebugAllHoverEvent(ConfigWrap.mainOpt().phantomDebug));
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private class_2561 createDebugAllHoverEvent(boolean debug) {
        class_5250 text = class_2561.method_43470((String)" ");
        text.method_27693(debug ? "\u00a7dON\u00a7r" : "\u00a7bOFF\u00a7r");
        return text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + this.getName() + " debug-all " + (debug ? "false" : "true"))));
    }

    private int save(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> InitWrap.text().formatText("Saving config!"), false);
        ConfigManager.getInstance().saveEach((IConfigDispatch)PhantomSpawningConfigHandler.getInstance());
        String user = ((class_2168)ctx.getSource()).method_9214();
        PhantomSpawningMod.LOGGER.info("{} has saved the configuration.", (Object)user);
        return 1;
    }

    private int reload(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> InitWrap.text().formatText("Reloaded config!"), false);
        ConfigManager.getInstance().reloadEach((IConfigDispatch)PhantomSpawningConfigHandler.getInstance());
        String user = ((class_2168)ctx.getSource()).method_9214();
        PhantomSpawningMod.LOGGER.info("{} has reloaded the configuration.", (Object)user);
        return 1;
    }

    private int infoPlayer(CommandContext<class_2168> ctx) {
        try {
            return this.infoPlayer(ctx, ((class_2168)ctx.getSource()).method_9207());
        }
        catch (CommandSyntaxException err) {
            PhantomSpawningMod.LOGGER.warn("CMD:infoPlayer: Syntax Error; {}", (Object)err.getLocalizedMessage());
            return 0;
        }
    }

    private int infoPlayer(CommandContext<class_2168> ctx, class_3222 player) {
        Pair<Boolean, Integer> pair = PlayerManager.getInstance().getPlayerInfo(player);
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852(InitWrap.text().formatText("\u00a77Player Info for: ")).method_10852(player.method_5476()).method_10852(InitWrap.text().formatText("\n - \u00a77Phantom status:\u00a7r")).method_10852(this.createPlayerStatusHoverEvent(player, (Boolean)pair.getLeft())).method_10852(InitWrap.text().formatText("\n - \u00a77Time since rest:")).method_10852(this.createFormattedRestTimeStat(pair)).method_10852(InitWrap.text().formatText("\n - \u00a77Player debug status:\u00a7r")).method_10852(this.createPlayerDebugHoverEvent(player, PlayerManager.getInstance().getDebugStatus(player.method_5667())));
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private class_2561 createPlayerStatusHoverEvent(class_3222 player, boolean status) {
        class_5250 text = class_2561.method_43470((String)" ");
        String name = ProfileWrap.name(player.method_7334());
        text.method_27693(status ? "\u00a7cEnabled\u00a7r" : "\u00a7aDisabled\u00a7r");
        return text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + this.getName() + " toggle " + name + " " + (status ? "false" : "true"))).method_10975(name));
    }

    private class_2561 createFormattedRestTimeStat(Pair<Boolean, Integer> pair) {
        class_5250 text = class_2561.method_43470((String)" ");
        class_3445 stat = class_3468.field_15419.method_14956((Object)class_3468.field_15429);
        boolean canSpawn = (Integer)pair.getRight() >= 72000;
        return text.method_27693("\u00a7f" + stat.method_14953(((Integer)pair.getRight()).intValue())).method_27693(canSpawn ? (((Boolean)pair.getLeft()).booleanValue() ? " \u00a7c(" + String.valueOf(pair.getRight()) + ") \u00a7f[\u00a76Could Spawn\u00a7f]\u00a7r" : " \u00a7c(" + String.valueOf(pair.getRight()) + ")\u00a7r") : " \u00a7e(" + String.valueOf(pair.getRight()) + ")\u00a7r");
    }

    private class_2561 createPlayerDebugHoverEvent(class_3222 player, boolean debug) {
        class_5250 text = class_2561.method_43470((String)" ");
        String name = ProfileWrap.name(player.method_7334());
        text.method_27693(debug ? "\u00a7dON\u00a7r" : "\u00a7bOFF\u00a7r");
        return text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + this.getName() + " debug " + name + " " + (debug ? "false" : "true"))).method_10975(name));
    }

    private int displayAtRisk(CommandContext<class_2168> ctx) {
        class_5250 text = class_2561.method_43470((String)"");
        class_3324 list = ((class_2168)ctx.getSource()).method_9211().method_3760();
        int count = 0;
        text.method_27693("\u00a79Showing all at-risk players:\u00a7r\n");
        for (class_3222 player : list.method_14571()) {
            Pair<Boolean, Integer> pair = PlayerManager.getInstance().getPlayerInfo(player);
            if (!((Boolean)pair.getLeft()).booleanValue() || (Integer)pair.getRight() < 72000) continue;
            if (count > 0) {
                text.method_27693("\u00a7r\u00a7f, ");
            } else if (count == 0) {
                text.method_27693(" \u00a77- \u00a7f");
            }
            text.method_10852(this.createPlayerInfoHoverEvent(player)).method_27693("\n");
            ++count;
        }
        text.method_27693(String.format("\u00a76(%d total)\u00a7r", count));
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private class_2561 createPlayerInfoHoverEvent(class_3222 player) {
        String name = ProfileWrap.name(player.method_7334());
        class_5250 text = class_2561.method_43470((String)name);
        return text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + this.getName() + " info " + name)).method_10975(name));
    }

    private int togglePlayer(CommandContext<class_2168> ctx, class_3222 player) {
        return this.togglePlayer(ctx, player, !PlayerManager.getInstance().getPhantomStatus(player.method_7334()));
    }

    private int togglePlayer(CommandContext<class_2168> ctx, class_3222 player, boolean toggle) {
        PlayerManager.getInstance().setPhantomStatus(player.method_7334(), toggle);
        class_2561 text = toggle ? InitWrap.text().formatText("\u00a7cEnabled Phantom spawning; for player: \u00a7r") : InitWrap.text().formatText("\u00a7aDisabled Phantoms from spawning; for player: \u00a7r");
        ((class_5250)text).method_10852(player.method_5476());
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        if (toggle) {
            PhantomSpawningMod.LOGGER.info("Player: '{}' has enabled Phantom spawns.", (Object)player.method_5477().getString());
        } else {
            PhantomSpawningMod.LOGGER.info("Player: '{}' has disabled Phantom spawns.", (Object)player.method_5477().getString());
        }
        return 1;
    }

    private int debugPlayer(CommandContext<class_2168> ctx, class_3222 player) {
        return this.debugPlayer(ctx, player, !PlayerManager.getInstance().getDebugStatus(player.method_5667()));
    }

    private int debugPlayer(CommandContext<class_2168> ctx, class_3222 player, boolean toggle) {
        PlayerManager.getInstance().setDebugStatus(player.method_7334(), toggle);
        class_2561 text = toggle ? InitWrap.text().formatText("\u00a7dEnabled Phantom spawning debug; for player: \u00a7r") : InitWrap.text().formatText("\u00a7bDisabled Phantom spawning debug; for player: \u00a7r");
        ((class_5250)text).method_10852(player.method_5476());
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        if (toggle) {
            PhantomSpawningMod.LOGGER.info("Phantom spawn debug enabled for player: '{}'", (Object)player.method_5477().getString());
        } else {
            PhantomSpawningMod.LOGGER.info("Phantom spawn debug disabled for player: '{}'", (Object)player.method_5477().getString());
        }
        return 1;
    }

    private int toggleAll(CommandContext<class_2168> ctx) {
        return this.toggleAll(ctx, true);
    }

    private int toggleAll(CommandContext<class_2168> ctx, boolean toggle) {
        PlayerManager.getInstance().setPhantomStatusAll(toggle);
        class_2561 text = toggle ? InitWrap.text().formatText("\u00a7cEnabled Phantom spawning for all players\u00a7r") : InitWrap.text().formatText("\u00a7aDisabled Phantom spawning for all players\u00a7r");
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        if (toggle) {
            PhantomSpawningMod.LOGGER.info("Phantom spawning enabled for all players");
        } else {
            PhantomSpawningMod.LOGGER.info("Phantom spawning disabled for all players");
        }
        return 1;
    }

    private int debugAll(CommandContext<class_2168> ctx) {
        return this.debugAll(ctx, !ConfigWrap.mainOpt().phantomDebug);
    }

    private int debugAll(CommandContext<class_2168> ctx, boolean toggle) {
        PlayerManager.getInstance().setDebugStatusAll(toggle);
        ConfigWrap.mainOpt().phantomDebug = toggle;
        class_2561 text = toggle ? InitWrap.text().formatText("\u00a7dPhantom spawning debug enabled for all players\u00a7r") : InitWrap.text().formatText("\u00a7bPhantom spawning debug disabled for all players\u00a7r");
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        if (toggle) {
            PhantomSpawningMod.LOGGER.info("Phantom spawning debug enabled for all players");
        } else {
            PhantomSpawningMod.LOGGER.info("Phantom spawning debug disabled for all players");
        }
        return 1;
    }
}

