/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.events;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.corelib.api.events.IPlayerEventsDispatch;
import com.sakuraryoko.phantom_spawning.impl.PhantomSpawningMod;
import com.sakuraryoko.phantom_spawning.impl.config.ConfigWrap;
import com.sakuraryoko.phantom_spawning.impl.player.PlayerManager;
import java.net.SocketAddress;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PlayerEventsHandler
implements IPlayerEventsDispatch {
    private static final PlayerEventsHandler INSTANCE = new PlayerEventsHandler();

    public static PlayerEventsHandler getInstance() {
        return INSTANCE;
    }

    public void onConnection(SocketAddress addr, GameProfile profile, class_2561 result) {
    }

    public void onCreatePlayer(class_3222 player, GameProfile profile) {
        PlayerManager.getInstance().syncProfile(profile);
    }

    public void onPlayerJoinPre(class_3222 player, class_2535 connection) {
    }

    public void onPlayerJoinPost(class_3222 player, class_2535 connection) {
    }

    public void onPlayerRespawn(class_3222 newPlayer) {
        PlayerManager.getInstance().syncProfile(newPlayer.method_7334());
    }

    public void onPlayerLeave(class_3222 player) {
        PlayerManager.getInstance().syncProfile(player.method_7334());
    }

    public void onDisconnectAll() {
    }

    public void onSetViewDistance(int distance) {
    }

    public void onSetSimulationDistance(int distance) {
    }

    public Integer onCheckBypassInsomnia(@Nullable class_3222 player, Integer currentValue) {
        if (player == null) {
            return currentValue;
        }
        boolean debug = PlayerManager.getInstance().getDebugStatus(player.method_7334());
        if (!PlayerManager.getInstance().getPhantomStatus(player.method_7334())) {
            if (currentValue >= 71000) {
                if (ConfigWrap.mainOpt().phantomDebug || debug) {
                    PhantomSpawningMod.LOGGER.warn("onCheckBypassInsomnia: Player: ['{}'/false] - may have been spared from phantom spawns [{} -> 1]", (Object)player.method_5477().getString(), (Object)currentValue);
                }
                return 1;
            }
            if (ConfigWrap.mainOpt().phantomDebug || debug) {
                PhantomSpawningMod.LOGGER.warn("onCheckBypassInsomnia: Player: ['{}'/false] - current value: [{}]", (Object)player.method_5477().getString(), (Object)currentValue);
            }
        } else if (ConfigWrap.mainOpt().phantomDebug || debug) {
            PhantomSpawningMod.LOGGER.warn("onCheckBypassInsomnia: Player: ['{}'/true] - current value: [{}]", (Object)player.method_5477().getString(), (Object)currentValue);
        }
        return currentValue;
    }

    public void onPhantomSpawn(class_3222 player, int count) {
        if (ConfigWrap.mainOpt().phantomDebug || PlayerManager.getInstance().getDebugStatus(player.method_5667())) {
            boolean status = PlayerManager.getInstance().getPhantomStatus(player.method_7334());
            class_243 loc = player.method_19538();
            PhantomSpawningMod.LOGGER.warn("onPhantomSpawn: Target: ['{}'/{}] -- [{}] phantoms spawned near [{}, {}, {}]", (Object)player.method_5477().getString(), (Object)status, (Object)count, (Object)((int)loc.field_1352), (Object)((int)loc.field_1351), (Object)((int)loc.field_1350));
        }
    }
}

