/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.config;

import com.sakuraryoko.corelib.api.config.IConfigData;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.phantom_spawning.impl.PhantomSpawningMod;
import com.sakuraryoko.phantom_spawning.impl.config.data.PhantomSpawningData;
import com.sakuraryoko.phantom_spawning.impl.config.data.options.MainOptions;
import com.sakuraryoko.phantom_spawning.impl.config.data.options.PlayerOptions;
import com.sakuraryoko.phantom_spawning.impl.modinit.PhantomSpawningInit;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PhantomSpawningConfigHandler
implements IConfigDispatch {
    private static final PhantomSpawningConfigHandler INSTANCE = new PhantomSpawningConfigHandler();
    private final PhantomSpawningData CONFIG = this.newConfig();
    private final String CONFIG_ROOT = "phantom-spawning";
    private final String CONFIG_NAME = "phantom-spawning";
    private boolean loaded = false;

    public static PhantomSpawningConfigHandler getInstance() {
        return INSTANCE;
    }

    public String getConfigRoot() {
        Objects.requireNonNull(this);
        return "phantom-spawning";
    }

    public boolean useRootDir() {
        return true;
    }

    public String getConfigName() {
        Objects.requireNonNull(this);
        return "phantom-spawning";
    }

    public PhantomSpawningData newConfig() {
        return new PhantomSpawningData();
    }

    public PhantomSpawningData getConfig() {
        return this.CONFIG;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void initConfig() {
    }

    public void onPreLoadConfig() {
        this.loaded = false;
    }

    public void onPostLoadConfig() {
        this.loaded = true;
    }

    public void onPreSaveConfig() {
        this.loaded = false;
    }

    public void onPostSaveConfig() {
        this.loaded = true;
    }

    public PhantomSpawningData defaults() {
        PhantomSpawningData config = this.newConfig();
        PhantomSpawningMod.debugLog("PhantomSpawningConfigHandler#defaults(): Setting default config.", new Object[0]);
        config.config_date = TimeFormat.RFC1123.formatNow(null);
        config.MAIN = new MainOptions();
        config.PLAYERS = new ArrayList<PlayerOptions>();
        return config;
    }

    public PhantomSpawningData update(IConfigData newConfig) {
        PhantomSpawningData newConf = (PhantomSpawningData)newConfig;
        PhantomSpawningMod.debugLog("PhantomSpawningConfigHandler#update(): Refresh config.", new Object[0]);
        this.CONFIG.comment = PhantomSpawningInit.getInstance().getModVersionString() + " Config";
        this.CONFIG.config_date = TimeFormat.RFC1123.formatNow(null);
        PhantomSpawningMod.debugLog("PhantomSpawningConfigHandler#update(): save_date: {} --> {}", newConf.config_date, this.CONFIG.config_date);
        this.CONFIG.MAIN.copy(newConf.MAIN);
        this.CONFIG.PLAYERS.clear();
        this.CONFIG.PLAYERS.addAll(newConf.PLAYERS);
        return this.CONFIG;
    }

    public void execute(boolean fromInit) {
        PhantomSpawningMod.debugLog("PhantomSpawningConfigHandler#execute(): Execute config.", new Object[0]);
        if (!fromInit) {
            if (this.CONFIG.MAIN.phantomDebug) {
                PhantomSpawningMod.LOGGER.info("Phantom spawning debug is enabled for all players");
            } else {
                PhantomSpawningMod.LOGGER.info("Phantom spawning debug is disabled for all players");
            }
        }
        PhantomSpawningMod.debugLog("PhantomSpawningConfigHandler#execute(): new config_date: {}", this.CONFIG.config_date);
    }
}

