/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.config.data.options;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.corelib.api.config.IConfigOption;
import com.sakuraryoko.phantom_spawning.impl.player.ProfileWrap;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PlayerOptions
implements IConfigOption {
    public UUID uuid;
    public String name;
    public boolean phantomSpawning;

    public PlayerOptions() {
        this.defaults();
    }

    public void defaults() {
        this.uuid = UUID.randomUUID();
        this.name = this.uuid.toString();
        this.phantomSpawning = true;
    }

    public PlayerOptions copy(IConfigOption other) {
        PlayerOptions opts = (PlayerOptions)other;
        this.uuid = opts.uuid;
        this.name = opts.name;
        this.phantomSpawning = opts.phantomSpawning;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof PlayerOptions) {
            PlayerOptions opt = (PlayerOptions)o;
            return opt.uuid.equals(this.uuid);
        }
        return false;
    }

    public static PlayerOptions fromProfile(@NotNull GameProfile profile) {
        return PlayerOptions.fromProfile(profile, true);
    }

    public static PlayerOptions fromProfile(@NotNull GameProfile profile, boolean toggle) {
        PlayerOptions opts = new PlayerOptions();
        opts.uuid = ProfileWrap.id(profile);
        opts.name = ProfileWrap.name(profile);
        opts.phantomSpawning = toggle;
        return opts;
    }
}

