/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.phantom_spawning.impl.player;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.phantom_spawning.impl.PhantomSpawningMod;
import com.sakuraryoko.phantom_spawning.impl.config.ConfigWrap;
import com.sakuraryoko.phantom_spawning.impl.config.data.options.PlayerOptions;
import com.sakuraryoko.phantom_spawning.impl.player.ProfileWrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PlayerManager {
    private static final PlayerManager INSTANCE = new PlayerManager();
    private final HashMap<UUID, Boolean> playerMap = new HashMap();
    private final HashMap<UUID, Boolean> debugMap = new HashMap();

    public static PlayerManager getInstance() {
        return INSTANCE;
    }

    private PlayerManager() {
    }

    public void syncProfile(GameProfile profile) {
        List<PlayerOptions> config = ConfigWrap.players();
        UUID uuid = ProfileWrap.id(profile);
        for (PlayerOptions opt : config) {
            if (!opt.uuid.equals(uuid)) continue;
            this.addOrUpdateProfile(profile, opt.phantomSpawning);
            return;
        }
        this.addConfig(profile);
    }

    private void addOrUpdateProfile(GameProfile profile, boolean toggle) {
        UUID uuid = ProfileWrap.id(profile);
        if (this.playerMap.containsKey(uuid) && this.playerMap.get(uuid) != toggle) {
            this.playerMap.remove(uuid);
            this.playerMap.put(uuid, toggle);
        } else if (!this.playerMap.containsKey(uuid)) {
            this.playerMap.put(uuid, toggle);
        }
        this.debugMap.put(uuid, false);
        if (ConfigWrap.mainOpt().phantomDebug) {
            PhantomSpawningMod.LOGGER.warn("addOrUpdateProfile: player: ['{}'/{}] status: {}", (Object)ProfileWrap.name(profile), (Object)ProfileWrap.id(profile), (Object)toggle);
        }
    }

    private void addConfig(GameProfile profile) {
        ArrayList<PlayerOptions> config = new ArrayList<PlayerOptions>(ConfigWrap.players());
        boolean exists = false;
        for (PlayerOptions entry : config) {
            if (!entry.uuid.equals(ProfileWrap.id(profile))) continue;
            exists = true;
        }
        if (!exists) {
            ConfigWrap.players().add(PlayerOptions.fromProfile(profile, true));
        }
        if (ConfigWrap.mainOpt().phantomDebug) {
            PhantomSpawningMod.LOGGER.warn("addConfig: player: ['{}'/{}]", (Object)ProfileWrap.name(profile), (Object)ProfileWrap.id(profile));
        }
    }

    private void setConfig(GameProfile profile, boolean toggle) {
        ArrayList<PlayerOptions> config = new ArrayList<PlayerOptions>(ConfigWrap.players());
        boolean dirty = false;
        for (PlayerOptions entry : config) {
            if (!entry.uuid.equals(ProfileWrap.id(profile))) continue;
            entry.phantomSpawning = toggle;
            dirty = true;
        }
        if (dirty) {
            ConfigWrap.players().clear();
            ConfigWrap.players().addAll(config);
        }
    }

    public boolean getPhantomStatus(@NotNull GameProfile profile) {
        UUID uuid = ProfileWrap.id(profile);
        if (this.playerMap.containsKey(uuid)) {
            return this.playerMap.get(uuid);
        }
        this.addOrUpdateProfile(profile, true);
        this.addConfig(profile);
        return true;
    }

    public boolean getPhantomStatus(@NotNull UUID uuid) {
        if (this.playerMap.containsKey(uuid)) {
            return this.playerMap.get(uuid);
        }
        this.playerMap.put(uuid, true);
        return true;
    }

    public boolean getDebugStatus(@NotNull GameProfile profile) {
        UUID uuid = ProfileWrap.id(profile);
        if (this.debugMap.containsKey(uuid)) {
            return this.debugMap.get(uuid);
        }
        return false;
    }

    public boolean getDebugStatus(@NotNull UUID uuid) {
        if (this.debugMap.containsKey(uuid)) {
            return this.debugMap.get(uuid);
        }
        return false;
    }

    public Pair<Boolean, Integer> getPlayerInfo(@NotNull class_3222 player) {
        return Pair.of((Object)this.getPhantomStatus(player.method_7334()), (Object)class_3532.method_15340((int)player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429)), (int)1, (int)Integer.MAX_VALUE));
    }

    public void setPhantomStatus(@NotNull GameProfile profile, boolean toggle) {
        this.addOrUpdateProfile(profile, toggle);
        this.setConfig(profile, toggle);
        if (ConfigWrap.mainOpt().phantomDebug || this.getDebugStatus(profile)) {
            PhantomSpawningMod.LOGGER.warn("setPhantomStatus: player: ['{}'/{}] status: {}", (Object)ProfileWrap.name(profile), (Object)ProfileWrap.id(profile), (Object)toggle);
        }
    }

    public void setDebugStatus(@NotNull GameProfile profile, boolean toggle) {
        UUID uuid = ProfileWrap.id(profile);
        this.debugMap.put(uuid, toggle);
        if (ConfigWrap.mainOpt().phantomDebug || this.getDebugStatus(uuid)) {
            PhantomSpawningMod.LOGGER.warn("setDebugStatus: player: ['{}'/{}] status: {}", (Object)ProfileWrap.name(profile), (Object)ProfileWrap.id(profile), (Object)toggle);
        }
    }

    public void setPhantomStatusAll(boolean toggle) {
        for (UUID uuid : this.playerMap.keySet()) {
            this.playerMap.replace(uuid, toggle);
        }
        ArrayList<PlayerOptions> config = new ArrayList<PlayerOptions>(ConfigWrap.players());
        boolean dirty = false;
        for (PlayerOptions entry : config) {
            if (entry.phantomSpawning == toggle) continue;
            entry.phantomSpawning = toggle;
            dirty = true;
        }
        if (dirty) {
            ConfigWrap.players().clear();
            ConfigWrap.players().addAll(config);
        }
        if (ConfigWrap.mainOpt().phantomDebug) {
            PhantomSpawningMod.LOGGER.warn("setPhantomStatusAll: status: {}", (Object)toggle);
        }
    }

    public void setDebugStatusAll(boolean toggle) {
        for (UUID uuid : this.playerMap.keySet()) {
            this.debugMap.put(uuid, toggle);
        }
        if (ConfigWrap.mainOpt().phantomDebug) {
            PhantomSpawningMod.LOGGER.warn("setDebugStatusAll: status: {}", (Object)toggle);
        }
    }
}

