/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pickaxesplus.procedures;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class UpgradePickaxeBlockDestroyedWithToolProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        Block block = world.getBlockState(pos).getBlock();
        AABB area = new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 1.5, z + 0.5);
        for (ItemEntity drop : level.getEntitiesOfClass(ItemEntity.class, area, e -> true)) {
            drop.remove(Entity.RemovalReason.DISCARDED);
        }
        Consumer<ItemStack> spawn = stack -> {
            ItemEntity e = new ItemEntity((Level)level, x, y, z, stack);
            e.setPickUpDelay(10);
            level.addFreshEntity((Entity)e);
        };
        if (block == Blocks.COAL_ORE || block == Blocks.DEEPSLATE_COAL_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.IRON_INGOT));
        } else if (block == Blocks.COPPER_ORE || block == Blocks.DEEPSLATE_COPPER_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.IRON_INGOT));
        } else if (block == Blocks.IRON_ORE || block == Blocks.DEEPSLATE_IRON_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.GOLD_INGOT));
        } else if (block == Blocks.GOLD_ORE || block == Blocks.DEEPSLATE_GOLD_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.DIAMOND));
        } else if (block == Blocks.LAPIS_ORE || block == Blocks.DEEPSLATE_LAPIS_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.EMERALD));
        } else if (block == Blocks.EMERALD_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.DIAMOND));
        } else if (block == Blocks.DIAMOND_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE) {
            spawn.accept(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
        } else if (block == Blocks.ANCIENT_DEBRIS) {
            spawn.accept(new ItemStack((ItemLike)Items.NETHERITE_BLOCK));
        }
    }
}

