/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pickaxesplus.procedures;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class AutoSmeltPickaxeBlockDestroyedWithToolProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        Block block = world.getBlockState(pos).getBlock();
        Consumer<ItemStack> drop = stack -> {
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                ItemEntity e = new ItemEntity((Level)_level, x, y, z, stack);
                e.setPickUpDelay(10);
                _level.addFreshEntity((Entity)e);
            }
        };
        if (block == Blocks.IRON_ORE || block == Blocks.DEEPSLATE_IRON_ORE) {
            drop.accept(new ItemStack((ItemLike)Items.IRON_INGOT));
        } else if (block == Blocks.GOLD_ORE || block == Blocks.DEEPSLATE_GOLD_ORE) {
            drop.accept(new ItemStack((ItemLike)Items.GOLD_INGOT));
        } else if (block == Blocks.COPPER_ORE || block == Blocks.DEEPSLATE_COPPER_ORE) {
            drop.accept(new ItemStack((ItemLike)Items.COPPER_INGOT));
        } else if (block == Blocks.ANCIENT_DEBRIS) {
            drop.accept(new ItemStack((ItemLike)Items.NETHERITE_SCRAP));
        } else if (block == Blocks.COAL_ORE || block == Blocks.DEEPSLATE_COAL_ORE) {
            drop.accept(new ItemStack((ItemLike)Items.COAL));
        }
    }
}

