/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pickaxesplus.procedures;

import net.mcreator.pickaxesplus.init.PickaxesplusModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class FeatherPickaxeOnHoldProcedure {
    private static final int FLIGHT_MAX_TICKS = 100;
    private static final int FLIGHT_COOLDOWN = 200;
    private static final String NBT_FLIGHT_TIME = "PickaxeFlight_Time";
    private static final String NBT_FLIGHT_COOLDOWN = "PickaxeFlight_Cooldown";
    private static final String NBT_WAS_HOLDING = "PickaxeFlight_WasHolding";
    private static final String NBT_PENDING_LANDING = "PickaxeFlight_PendingLanding";
    private static final String NBT_LAND_X = "PickaxeFlight_LandX";
    private static final String NBT_LAND_Y = "PickaxeFlight_LandY";
    private static final String NBT_LAND_Z = "PickaxeFlight_LandZ";
    private static final String NBT_START_Y = "PickaxeFlight_StartY";
    private static final int MAX_SCAN_DOWN = 60;
    private static final double MIN_FALL_FOR_EXPLOSION = 3.0;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = entity;
        ItemStack mainHand = player.getMainHandItem();
        boolean holdingPick = mainHand.getItem() == PickaxesplusModItems.FEATHER_PICKAXE.get();
        CompoundTag data = player.getPersistentData();
        int timeLeft = data.getInt(NBT_FLIGHT_TIME);
        int cooldown = data.getInt(NBT_FLIGHT_COOLDOWN);
        boolean wasHolding = data.getBoolean(NBT_WAS_HOLDING);
        boolean pendingLanding = data.getBoolean(NBT_PENDING_LANDING);
        if (cooldown > 0) {
            data.putInt(NBT_FLIGHT_COOLDOWN, --cooldown);
        }
        if (holdingPick) {
            if (cooldown > 0) {
                if (!player.isCreative() && !player.isSpectator()) {
                    player.getAbilities().mayfly = false;
                    player.getAbilities().flying = false;
                    if (!player.level().isClientSide()) {
                        player.onUpdateAbilities();
                    }
                }
                if (player.level().isClientSide()) {
                    player.displayClientMessage((Component)Component.literal((String)("\u00a7cFlight cooling down... " + cooldown / 20 + "s")), true);
                }
            } else if (!wasHolding) {
                player.getAbilities().mayfly = true;
                player.getAbilities().flying = true;
                if (!player.level().isClientSide()) {
                    player.onUpdateAbilities();
                }
                if (player.level().isClientSide()) {
                    player.displayClientMessage((Component)Component.literal((String)"\u00a7b\u2708 Flight ENABLED (5s)"), true);
                }
                timeLeft = 100;
                pendingLanding = false;
                data.putBoolean(NBT_PENDING_LANDING, false);
            } else if (timeLeft > 0 && --timeLeft == 0) {
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                if (!player.level().isClientSide()) {
                    player.onUpdateAbilities();
                }
                cooldown = 200;
                data.putInt(NBT_FLIGHT_COOLDOWN, cooldown);
                if (player.level().isClientSide()) {
                    player.displayClientMessage((Component)Component.literal((String)"\u00a7eFlight ended. Cooling down..."), true);
                }
                if (!(player.onGround() || player.isCreative() || player.isSpectator())) {
                    FeatherPickaxeOnHoldProcedure.scheduleLanding(player, data);
                    pendingLanding = true;
                    data.putBoolean(NBT_PENDING_LANDING, true);
                    data.putDouble(NBT_START_Y, player.getY());
                }
            }
        } else {
            if (wasHolding && !player.onGround() && !player.isCreative() && !player.isSpectator()) {
                FeatherPickaxeOnHoldProcedure.scheduleLanding(player, data);
                pendingLanding = true;
                data.putBoolean(NBT_PENDING_LANDING, true);
                data.putDouble(NBT_START_Y, player.getY());
            }
            if (!player.isCreative() && !player.isSpectator()) {
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                if (!player.level().isClientSide()) {
                    player.onUpdateAbilities();
                }
            }
        }
        if (pendingLanding) {
            double desiredSpeed;
            Level level = player.level();
            if (level.isClientSide()) {
                player.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), 0.0, 0.02, 0.0);
            }
            if (player.hasEffect(MobEffects.SLOW_FALLING) && player.getDeltaMovement().y > (desiredSpeed = -0.5)) {
                player.setDeltaMovement(player.getDeltaMovement().x, desiredSpeed, player.getDeltaMovement().z);
            }
            if (!level.isClientSide()) {
                if (player.onGround() || data.contains(NBT_LAND_Y) && player.getY() <= (double)data.getInt(NBT_LAND_Y) + 1.8) {
                    BlockPos landingPos = player.blockPosition();
                    data.putInt(NBT_LAND_X, landingPos.getX());
                    data.putInt(NBT_LAND_Y, landingPos.getY());
                    data.putInt(NBT_LAND_Z, landingPos.getZ());
                    FeatherPickaxeOnHoldProcedure.triggerLanding((ServerLevel)level, player, data);
                    pendingLanding = false;
                    data.putBoolean(NBT_PENDING_LANDING, false);
                    data.remove(NBT_LAND_X);
                    data.remove(NBT_LAND_Y);
                    data.remove(NBT_LAND_Z);
                    data.remove(NBT_START_Y);
                } else {
                    int groundY = FeatherPickaxeOnHoldProcedure.findGroundY(level, player);
                    if (groundY != -1) {
                        data.putInt(NBT_LAND_Y, groundY);
                    }
                }
            }
        }
        data.putInt(NBT_FLIGHT_TIME, timeLeft);
        data.putInt(NBT_FLIGHT_COOLDOWN, cooldown);
        data.putBoolean(NBT_WAS_HOLDING, holdingPick);
    }

    private static void scheduleLanding(Player player, CompoundTag data) {
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        int slowDuration = 200;
        MobEffectInstance slowFall = new MobEffectInstance(MobEffects.SLOW_FALLING, slowDuration, 0, false, false, false);
        player.addEffect(slowFall);
    }

    private static int findGroundY(Level level, Player player) {
        double startY = player.getY();
        for (int i = 1; i <= 60; ++i) {
            BlockPos check = BlockPos.containing((double)player.getX(), (double)(startY - (double)i), (double)player.getZ());
            if (level.getBlockState(check).isAir()) continue;
            return check.getY();
        }
        return -1;
    }

    private static void triggerLanding(ServerLevel serverLevel, Player player, CompoundTag data) {
        double dx;
        try {
            player.removeEffect(MobEffects.SLOW_FALLING);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, player.getX(), player.getY(), player.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), 50, 1.0, 0.5, 1.0, 0.1);
        int lx = data.contains(NBT_LAND_X) ? data.getInt(NBT_LAND_X) : player.blockPosition().getX();
        int ly = data.contains(NBT_LAND_Y) ? data.getInt(NBT_LAND_Y) : player.blockPosition().getY();
        int lz = data.contains(NBT_LAND_Z) ? data.getInt(NBT_LAND_Z) : player.blockPosition().getZ();
        double ex = (double)lx + 0.5;
        double ey = ly;
        double ez = (double)lz + 0.5;
        double startY = data.contains(NBT_START_Y) ? data.getDouble(NBT_START_Y) : player.getY();
        double fallDistance = Math.max(0.0, startY - (double)ly);
        if (fallDistance < 3.0) {
            return;
        }
        float power = (float)Math.min(6.0, Math.max(1.0, fallDistance / 2.0));
        double powerSq = power * power;
        for (int bx = (int)Math.floor(ex - (double)power); bx <= (int)Math.ceil(ex + (double)power); ++bx) {
            for (int by = (int)Math.floor(ey - (double)(power / 2.0f)); by <= (int)Math.ceil(ey + 1.0); ++by) {
                for (int bz = (int)Math.floor(ez - (double)power); bz <= (int)Math.ceil(ez + (double)power); ++bz) {
                    dx = (double)bx + 0.5 - ex;
                    double dz = (double)bz + 0.5 - ez;
                    double distSq = dx * dx + dz * dz + Math.pow(((double)by - ey) * 1.5, 2.0);
                    if (!(distSq <= powerSq)) continue;
                    BlockPos pos = new BlockPos(bx, by, bz);
                    serverLevel.destroyBlock(pos, true);
                }
            }
        }
        AABB area = new AABB(ex - (double)power, ey - (double)power, ez - (double)power, ex + (double)power, ey + (double)power, ez + (double)power);
        for (LivingEntity ent : serverLevel.getEntitiesOfClass(LivingEntity.class, area)) {
            double dz;
            double dy;
            double dist;
            if (ent == player || !((dist = Math.sqrt((dx = ent.getX() - ex) * dx + (dy = ent.getY() - ey) * dy + (dz = ent.getZ() - ez) * dz)) <= (double)power)) continue;
            float baseDamage = (float)Math.max(1.0, fallDistance * 2.0);
            float dmg = (float)Math.max(1.0, (double)baseDamage * (1.0 - dist / (double)power));
            ent.setHealth(Math.max(0.0f, ent.getHealth() - dmg));
        }
    }
}

