/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.FixedTabulaModel;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;

@OnlyIn(value=Dist.CLIENT)
public class AnimatableModel
extends FixedTabulaModel {
    public AnimatableModel(TabulaModelContainer model) {
        this(model, (ITabulaModelAnimator)null);
    }

    public AnimatableModel(TabulaModelContainer model, ITabulaModelAnimator animator) {
        super(model, animator);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof Animatable) {
            Animatable animatable = (Animatable)entity;
            if (animatable.isCarcass()) {
                this.setMovementScale(0.0f);
            } else {
                this.setMovementScale(animatable.isSleeping() ? 0.5f : 1.0f);
            }
        }
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public String[] getCubeIdentifierArray() {
        String[] cubeIdentifiers = new String[this.identifierMap.size()];
        int index = 0;
        Set identifiers = this.identifierMap.keySet();
        Iterator iterator = identifiers.iterator();
        while (iterator.hasNext()) {
            String identifier;
            cubeIdentifiers[index] = identifier = (String)iterator.next();
            ++index;
        }
        return cubeIdentifiers;
    }

    public String[] getCubeNames() {
        String[] cubeNames = new String[this.cubes.size()];
        int index = 0;
        Set names = this.cubes.keySet();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String identifier;
            cubeNames[index] = identifier = (String)iterator.next();
            ++index;
        }
        return cubeNames;
    }

    public Map<String, AdvancedModelBox> getIdentifierCubes() {
        return this.identifierMap;
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedModelBox ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = Mth.m_14036_((float)Mth.m_14177_((float)yaw), (float)-45.0f, (float)45.0f) / 57.295776f / actualRotationDivisor;
        float pitchAmount = Mth.m_14177_((float)pitch) / 57.295776f / actualRotationDivisor;
        for (AdvancedModelBox box : boxes) {
            box.rotateAngleY += yawAmount;
            box.rotateAngleX += pitchAmount;
        }
    }
}

