/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlock;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlockEntity;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailModel;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class TourRailBlockEntityRenderer
extends GeoBlockRenderer<TourRailBlockEntity> {
    public TourRailBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new TourRailModel());
        this.addRenderLayer(new StripeLayer((GeoRenderer<TourRailBlockEntity>)this));
    }

    public ResourceLocation getTextureLocation(TourRailBlockEntity tile) {
        return JurassicReborn.resource("textures/block/" + tile.getDirection().modelName + ".png");
    }

    public ResourceLocation getStripeTexture(TourRailBlockEntity tile) {
        return JurassicReborn.resource("textures/block/" + tile.getDirection().modelName + "_stripe.png");
    }

    public void preRender(PoseStack poseStack, TourRailBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        TourRailBlock.EnumRailDirection railDir = animatable.getDirection();
        if (railDir.isAscending()) {
            float sx = 1.0f;
            float sz = 1.0f;
            switch (railDir.getFacing()) {
                case EAST: 
                case WEST: {
                    sx = 0.7f;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    sz = 0.7f;
                    break;
                }
            }
            poseStack.m_85841_(sx, 1.0f, sz);
            double corr = 0.15;
            double neg = 0.125;
            switch (railDir.getFacing()) {
                case WEST: {
                    poseStack.m_85837_(corr + neg, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    poseStack.m_85837_(0.0, 0.0, corr + neg);
                    break;
                }
                case EAST: {
                    poseStack.m_85837_(corr, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85837_(0.0, 0.0, corr);
                    break;
                }
            }
        }
        poseStack.m_85837_(0.0, 0.01, 0.0);
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        if (this.animatable != null) {
            int rot = ((TourRailBlockEntity)this.animatable).getDirection().rotation;
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)rot));
        } else {
            super.rotateBlock(facing, poseStack);
        }
    }

    private static class StripeLayer
    extends GeoRenderLayer<TourRailBlockEntity> {
        public StripeLayer(GeoRenderer<TourRailBlockEntity> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, TourRailBlockEntity animatable, BakedGeoModel bakedModel, RenderType baseRenderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            BlockState state = animatable.m_58900_();
            Block block = state.m_60734_();
            if (!(block instanceof TourRailBlock)) {
                return;
            }
            TourRailBlock railBlock = (TourRailBlock)block;
            int rgb = railBlock.getSpeedType().getColor();
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            ResourceLocation stripeTex = JurassicReborn.resource("textures/block/" + animatable.getDirection().modelName + "_stripe.png");
            RenderType stripeType = RenderType.m_110458_((ResourceLocation)stripeTex);
            VertexConsumer stripeBuffer = bufferSource.m_6299_(stripeType);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, stripeType, stripeBuffer, partialTick, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }
}

