/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.entity.SharkAnimator;
import net.vit.jurassicreborn.common.entities.animal.SharkEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class SharkEntityRenderer
extends LivingEntityRenderer<SharkEntity, BasicEntityModel<SharkEntity>> {
    private static ResourceLocation SHARK_TEXTURE;
    private static final AnimatableModel SHARK;

    public SharkEntityRenderer(EntityRendererProvider.Context pContext, float pShadowRadius) {
        super(pContext, (EntityModel)SHARK, pShadowRadius);
        if (SHARK != null) {
            this.f_115290_ = SHARK;
        }
    }

    protected void scale(SharkEntity entity, PoseStack pMatrixStack, float pPartialTickTime) {
        float scale = entity.m_6162_() ? 0.2f : 1.7f;
        pMatrixStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, pMatrixStack, pPartialTickTime);
    }

    public void render(SharkEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(SharkEntity pEntity) {
        return SHARK_TEXTURE;
    }

    static {
        TabulaModelContainer shark = null;
        try {
            shark = TabulaModelHelper.loadTabulaModel("assets/jurassicreborn/models/entities/shark/adult/shark");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SHARK = new AnimatableModel(shark, new SharkAnimator());
        SHARK_TEXTURE = new ResourceLocation("jurassicreborn", "textures/entities/shark/shark.png");
    }
}

