/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.SkullDisplayBlock;
import net.vit.jurassicreborn.common.blocks.entities.SkullDisplayBlockEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class SkullDisplayRenderer
implements BlockEntityRenderer<SkullDisplayBlockEntity> {
    private static final int MAX_TEXTURE_SIZE = 2048;
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_CACHE = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();

    public SkullDisplayRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SkullDisplayBlockEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean horizontal;
        BlockState state = tile.m_58900_();
        if (state.m_60734_() != ModBlocks.SKULL_DISPLAY.get()) {
            return;
        }
        boolean bl = horizontal = ((Direction)state.m_61143_((Property)SkullDisplayBlock.FACING)).m_122434_() == Direction.Axis.Y;
        if (tile.model == null && tile.hasData()) {
            try {
                String dino = tile.getDinosaur().getName().toLowerCase(Locale.ENGLISH).replace(' ', '_');
                String modelOrient = horizontal ? "horizontal" : "vertical";
                String textureOrient = horizontal ? "vertical" : "horizontal";
                TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicreborn", "models/block/skull_display/" + dino + "_" + modelOrient));
                tile.model = new TabulaModel(container);
                if (container != null && container.getScale() != null && container.getScale().length >= 3) {
                    tile.modelScale = new float[]{(float)container.getScale()[0], (float)container.getScale()[1], (float)container.getScale()[2]};
                }
                ResourceLocation textureLocation = new ResourceLocation("jurassicreborn", "textures/block/skull_display/" + dino + "_" + (tile.isFossilized() ? "fossilized" : "fresh") + "_" + textureOrient + ".png");
                tile.texture = SkullDisplayRenderer.ensureTextureSize(textureLocation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)tile.getAngle()));
        float sx = tile.modelScale[0];
        float sy = tile.modelScale[1];
        float sz = tile.modelScale[2];
        poseStack.m_85841_(1.6f * sx, -1.6f * sy, 1.6f * sz);
        if (!horizontal) {
            poseStack.m_252880_(0.0f, 0.15f * sy, -0.18f * sz);
        }
        poseStack.m_252880_(0.0f, -1.194f * sy, 0.0f);
        if (tile.model != null) {
            VertexConsumer vc = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tile.texture));
            tile.model.m_7695_(poseStack, vc, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    private static ResourceLocation ensureTextureSize(ResourceLocation requested) {
        ResourceLocation resolved = SkullDisplayRenderer.resolveExistingTexture(requested);
        return TEXTURE_CACHE.computeIfAbsent(resolved, SkullDisplayRenderer::loadOrScaleTexture);
    }

    private static ResourceLocation resolveExistingTexture(ResourceLocation requested) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91098_().m_213713_(requested).isPresent()) {
            return requested;
        }
        String path = requested.m_135815_();
        if (path.startsWith("textures/block/")) {
            String fallbackPath = path.replace("textures/block/", "textures/");
            ResourceLocation fallback = new ResourceLocation(requested.m_135827_(), fallbackPath);
            if (minecraft.m_91098_().m_213713_(fallback).isPresent()) {
                return fallback;
            }
        }
        return requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocation loadOrScaleTexture(ResourceLocation original) {
        ResourceLocation resourceLocation;
        Minecraft minecraft = Minecraft.m_91087_();
        TextureManager textureManager = minecraft.m_91097_();
        Optional optionalResource = minecraft.m_91098_().m_213713_(original);
        if (optionalResource.isEmpty()) {
            return original;
        }
        Resource resource = (Resource)optionalResource.get();
        InputStream stream = null;
        try {
            stream = resource.m_215507_();
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            int width = image.m_84982_();
            int height = image.m_85084_();
            if (width <= 2048 && height <= 2048) {
                image.close();
                ResourceLocation resourceLocation2 = original;
                return resourceLocation2;
            }
            float scaleFactor = Math.max((float)width / 2048.0f, (float)height / 2048.0f);
            int scaledWidth = Math.max(1, Math.round((float)width / scaleFactor));
            int scaledHeight = Math.max(1, Math.round((float)height / scaleFactor));
            NativeImage scaledImage = new NativeImage(scaledWidth, scaledHeight, false);
            float ratioX = (float)width / (float)scaledWidth;
            float ratioY = (float)height / (float)scaledHeight;
            for (int y = 0; y < scaledHeight; ++y) {
                int srcY = Math.min(height - 1, (int)((float)y * ratioY));
                for (int x = 0; x < scaledWidth; ++x) {
                    int srcX = Math.min(width - 1, (int)((float)x * ratioX));
                    scaledImage.m_84988_(x, y, image.m_84985_(srcX, srcY));
                }
            }
            image.close();
            DynamicTexture dynamicTexture = new DynamicTexture(scaledImage);
            String path = original.m_135815_();
            int dot = path.lastIndexOf(46);
            String base = dot >= 0 ? path.substring(0, dot) : path;
            String ext = dot >= 0 ? path.substring(dot) : "";
            ResourceLocation scaledLocation = new ResourceLocation(original.m_135827_(), base + "_scaled" + ext);
            textureManager.m_118495_(scaledLocation, (AbstractTexture)dynamicTexture);
            resourceLocation = scaledLocation;
        }
        catch (IOException e) {
            e.printStackTrace();
            ResourceLocation resourceLocation3 = original;
            return resourceLocation3;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resourceLocation;
    }
}

