/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.vit.jurassicreborn.client.render.entity.DinosaurRenderInfo;
import net.vit.jurassicreborn.client.render.entity.DinosaurRenderer;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;

public class TroodonRenderer
extends DinosaurRenderer {
    public TroodonRenderer(EntityRendererProvider.Context context, BasicEntityModel<DinosaurEntity> model, float shadowSize, DinosaurRenderInfo info) {
        super(context, model, shadowSize, info);
        this.m_115326_(new TroodonGlowLayer((RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>>)this));
    }

    private static class TroodonGlowLayer
    extends RenderLayer<DinosaurEntity, BasicEntityModel<DinosaurEntity>> {
        TroodonGlowLayer(RenderLayerParent<DinosaurEntity, BasicEntityModel<DinosaurEntity>> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.m_20145_() || entity.isSkeleton() || entity.areEyelidsClosed()) {
                return;
            }
            ResourceLocation eyesTexture = TroodonGlowLayer.resolveEyesTexture(entity);
            if (eyesTexture == null) {
                return;
            }
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)eyesTexture));
            ((BasicEntityModel)this.m_117386_()).m_7695_(poseStack, consumer, 0xF000F0, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }

        private static ResourceLocation resolveEyesTexture(DinosaurEntity entity) {
            String gender;
            Dinosaur dinosaur = entity.getDinosaur();
            String formattedName = dinosaur.getFormattedName();
            GrowthStage stage = entity.getGrowthStage();
            if (!dinosaur.doesSupportGrowthStage(stage)) {
                stage = GrowthStage.ADULT;
            }
            String stageName = stage.name().toLowerCase(Locale.ROOT);
            String basePath = "textures/entities/" + formattedName + "/";
            ResourceLocation gendered = new ResourceLocation("jurassicreborn", basePath + formattedName + "_" + (gender = entity.isMale() ? "male" : "female") + "_" + stageName + "_eyes.png");
            if (TroodonGlowLayer.textureExists(gendered)) {
                return gendered;
            }
            ResourceLocation stageOnly = new ResourceLocation("jurassicreborn", basePath + formattedName + "_" + stageName + "_eyes.png");
            if (TroodonGlowLayer.textureExists(stageOnly)) {
                return stageOnly;
            }
            ResourceLocation fallback = new ResourceLocation("jurassicreborn", basePath + formattedName + "_eyes.png");
            if (TroodonGlowLayer.textureExists(fallback)) {
                return fallback;
            }
            return null;
        }

        private static boolean textureExists(ResourceLocation location) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft == null) {
                return false;
            }
            return minecraft.m_91098_().m_213713_(location).isPresent();
        }
    }
}

