/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegalodonEntity;

@OnlyIn(value=Dist.CLIENT)
public class MegalodonAnimator
extends EntityAnimator<MegalodonEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, MegalodonEntity entity, float f, float f1, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox[] advancedModelBoxArray;
        AdvancedModelBox body = model.getCube("Body");
        AdvancedModelBox head = model.getCube("Head");
        AdvancedModelBox pecL = model.getCube("LeftPectoral");
        AdvancedModelBox pecR = model.getCube("RightPectoral");
        AdvancedModelBox analFin = model.getCube("AnalFin");
        AdvancedModelBox pelvicL = model.getCube("PelvicL");
        AdvancedModelBox pelvicR = model.getCube("PelvicR");
        AdvancedModelBox tail1 = model.getCube("Tail1");
        AdvancedModelBox tail2 = model.getCube("Tail2");
        AdvancedModelBox tail3 = model.getCube("Tail3");
        AdvancedModelBox tail4 = model.getCube("Tail4");
        AdvancedModelBox tail5 = model.getCube("Tail5");
        AdvancedModelBox tail6 = model.getCube("Tail6");
        AdvancedModelBox[] tail = new AdvancedModelBox[]{tail6, tail5, tail4, tail3, tail2, tail1};
        if (body != null) {
            AdvancedModelBox[] advancedModelBoxArray2 = new AdvancedModelBox[1];
            advancedModelBoxArray = advancedModelBoxArray2;
            advancedModelBoxArray2[0] = body;
        } else {
            advancedModelBoxArray = new AdvancedModelBox[]{};
        }
        AdvancedModelBox[] spine = advancedModelBoxArray;
        boolean inWater = entity.m_20069_();
        float swimSpeed = 0.2f;
        float swimDegree = 0.09f;
        float waveFactor = 0.05f;
        float bobSpeed = 0.16f;
        float bobDegree = 0.025f;
        float flopSpeed = 0.3f;
        float flopDegree = 0.12f;
        if (body != null) {
            model.bob(body, inWater ? bobSpeed : 0.45f, inWater ? bobDegree : 0.1f, false, ticks, 1.0f);
        }
        if (inWater) {
            model.chainSwing(tail, swimSpeed, swimDegree, 2.0, ticks, 1.0f);
            model.chainWave(tail, swimSpeed * 0.55f, swimDegree * waveFactor, 2.0, ticks, 1.0f);
            if (spine.length > 0) {
                model.chainSwing(spine, swimSpeed * 0.7f, -swimDegree * 0.18f, 2.0, ticks + 0.5f, 0.9f);
            }
            if (pecL != null && pecR != null) {
                float pF = 0.4f;
                float pA = 0.07f;
                float s = (float)Math.sin(ticks * pF);
                float c = (float)Math.cos(ticks * pF);
                pecL.rotateAngleZ += s * (pA * 0.65f) - 0.18f;
                pecR.rotateAngleZ += -s * (pA * 0.65f) + 0.18f;
                pecL.rotateAngleX += c * (pA * 0.2f);
                pecR.rotateAngleX += -c * (pA * 0.2f);
            }
            if (pelvicL != null && pelvicR != null) {
                float s = 0.02f;
                float sw = (float)Math.sin(ticks * 0.55f);
                pelvicL.rotateAngleZ += s * sw;
                pelvicR.rotateAngleZ += -s * sw;
            }
            if (analFin != null) {
                analFin.rotateAngleY += 0.012f * (float)Math.sin(ticks * 0.6f);
            }
        } else {
            model.chainSwing(tail, flopSpeed, flopDegree, 2.0, ticks, 1.0f);
            if (spine.length > 0) {
                model.chainSwing(spine, flopSpeed * 0.7f, -flopDegree * 0.18f, 2.0, ticks, 0.9f);
            }
            if (pecL != null) {
                pecL.rotateAngleZ -= 0.22f;
                pecL.rotateAngleX += 0.15f;
            }
            if (pecR != null) {
                pecR.rotateAngleZ += 0.22f;
                pecR.rotateAngleX += 0.15f;
            }
        }
        if (head != null) {
            float damp = 0.3f;
            model.faceTarget(rotationYaw * damp, rotationPitch * damp, 0.35f, head);
            float maxYaw = (float)Math.toRadians(10.0);
            float maxPitch = (float)Math.toRadians(8.0);
            if (head.rotateAngleY > maxYaw) {
                head.rotateAngleY = maxYaw;
            }
            if (head.rotateAngleY < -maxYaw) {
                head.rotateAngleY = -maxYaw;
            }
            if (head.rotateAngleX > maxPitch) {
                head.rotateAngleX = maxPitch;
            }
            if (head.rotateAngleX < -maxPitch) {
                head.rotateAngleX = -maxPitch;
            }
        }
    }
}

