/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens.paleopad;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.screens.PaleoPadScreen;
import net.vit.jurassicreborn.client.screens.paleopad.GuiApp;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.paleopad.App;
import net.vit.jurassicreborn.common.paleopad.FeederTrackerApp;

public class FeederTrackerGuiApp
extends GuiApp {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/feeder_tracker.png");
    private int scroll;

    public FeederTrackerGuiApp(App app) {
        super(app);
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, Screen screen, float partialTicks) {
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        FeederTrackerApp tracker = (FeederTrackerApp)this.app;
        List<FeederTrackerApp.TrackedFeeder> list = tracker.getFeeders();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int visible = 5;
        int y = top + 20;
        for (int i = 0; i < visible && this.scroll + i < list.size(); ++i) {
            String label;
            FeederTrackerApp.TrackedFeeder f = list.get(this.scroll + i);
            int color = 0xFFFFFF;
            if (level != null && level.m_7702_(f.pos) instanceof FeederBlockEntity) {
                int food = tracker.getFood((Level)level, f);
                color = food <= 10 ? 0xFF4040 : 0xFFFFFF;
                label = f.name + " - " + food;
            } else {
                label = f.name + " - (Out of range!)";
            }
            ((PaleoPadScreen)screen).drawScaledText(poseStack, label, left + 10, y, 0.9f, color);
            y += 12;
        }
        int trackX = left + 190;
        int trackY = top + 20;
        int trackHeight = visible * 12;
        ((PaleoPadScreen)screen).drawScaledRect(poseStack, trackX, trackY, 4, trackHeight, 1.0f, -13619152);
        int total = list.size();
        if (total > visible) {
            int knobHeight = Math.max(8, trackHeight * visible / total);
            int maxScroll = total - visible;
            int knobY = trackY + (trackHeight - knobHeight) * this.scroll / maxScroll;
            ((PaleoPadScreen)screen).drawScaledRect(poseStack, trackX, knobY, 4, knobHeight, 1.0f, -8355712);
        }
    }

    @Override
    public void actionPerformed(Button button) {
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, Screen screen) {
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        int trackX = left + 190;
        int trackY = top + 20;
        int trackHeight = 60;
        int total = ((FeederTrackerApp)this.app).getFeeders().size();
        int visible = 5;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 4) && mouseY >= (double)trackY && mouseY <= (double)(trackY + trackHeight) && total > visible) {
            int knobHeight = Math.max(8, trackHeight * visible / total);
            int maxScroll = total - visible;
            int rel = (int)mouseY - trackY - knobHeight / 2;
            this.scroll = Mth.m_14045_((int)((int)((double)rel / (double)(trackHeight - knobHeight) * (double)maxScroll)), (int)0, (int)maxScroll);
        }
    }

    @Override
    public void init() {
        this.scroll = 0;
    }

    @Override
    public ResourceLocation getTexture(Screen screen) {
        return TEXTURE;
    }
}

