/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.entities.SkullDisplayBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.Fossils.FossilItem;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullDisplayBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)-2.0, (double)0.0, (double)-2.0, (double)18.0, (double)20.0, (double)18.0);
    private static final VoxelShape SHAPE_SIDE = Block.m_49796_((double)0.0, (double)-4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SkullDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SkullDisplayBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)FACING) == Direction.UP ? SHAPE_UP : SHAPE_SIDE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return SkullDisplayBlock.canBlockStay(level, pos, state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.checkAndDropBlock(level, pos, state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        this.checkAndDropBlock((Level)level, pos, state);
    }

    private void checkAndDropBlock(Level world, BlockPos pos, BlockState state) {
        if (!SkullDisplayBlock.canBlockStay((LevelReader)world, pos, state)) {
            List<ItemStack> drops = this.m_7381_(state, new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78984_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(pos)));
            for (ItemStack drop : drops) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private static boolean canBlockStay(LevelReader world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122434_() == Direction.Axis.Y) {
            return world.m_8055_(pos.m_7495_()).m_60815_();
        }
        return world.m_8055_(pos.m_121945_(SkullDisplayBlock.mirror(facing))).m_60815_();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61362_});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof SkullDisplayBlockEntity) {
            SkullDisplayBlockEntity tile = (SkullDisplayBlockEntity)be;
            return SkullDisplayBlock.getItemFromTile(tile);
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getItemFromTile(SkullDisplayBlockEntity tile) {
        Map map;
        Dinosaur dino = tile.getDinosaur();
        if (dino == null) {
            return ItemStack.f_41583_;
        }
        Map map2 = map = tile.isFossilized() ? (Map)ModItems.BONES.get(dino) : (Map)ModItems.FRESH_BONES.get(dino);
        if (map == null) {
            return ItemStack.f_41583_;
        }
        RegistryObject entry = (RegistryObject)map.get("skull");
        if (entry == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)entry.get());
        FossilItem.setHasStand(stack, tile.hasStand());
        return stack;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        SkullDisplayBlockEntity tile;
        ItemStack item;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        BlockEntity blockEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof SkullDisplayBlockEntity && !(item = SkullDisplayBlock.getItemFromTile(tile = (SkullDisplayBlockEntity)blockEntity)).m_41619_()) {
            drops.add(item);
        }
        return drops;
    }

    private static Direction mirror(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.EAST -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
            default -> facing;
        };
    }
}

