/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.ancientplants.moss;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.ancientplants.moss.PeatBlock;

public class AncientMossCarpet
extends Block {
    private static final int DENSITY_PER_AREA = 8;
    private static final int SPREAD_RADIUS = 3;

    public AncientMossCarpet() {
        super(ModBlocks.defaultMoss().m_60977_());
    }

    public AncientMossCarpet(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() instanceof PeatBlock && rand.m_188503_(8) <= 3) {
            int allowedInArea = 8;
            BlockPos nextPos = null;
            for (int placementAttempts = 3; nextPos == null && placementAttempts > 0; --placementAttempts) {
                int doubleRadius = 6;
                BlockPos tmp = pos.m_7918_(rand.m_188503_(doubleRadius) - 3, -3, rand.m_188503_(doubleRadius) - 3);
                nextPos = this.findGround((Level)world, tmp);
            }
            if (nextPos != null) {
                for (BlockPos neighbourPos : BlockPos.m_121940_((BlockPos)nextPos.m_7918_(-2, -3, -2), (BlockPos)nextPos.m_7918_(2, 3, 2))) {
                    if (world.m_8055_(neighbourPos).m_60734_() != this || --allowedInArea > 0) continue;
                    return;
                }
                world.m_7731_(nextPos, this.m_49966_(), 1);
            }
        }
    }

    private BlockPos findGround(Level world, BlockPos start) {
        BlockPos pos = start;
        Block down = world.m_8055_(pos.m_7495_()).m_60734_();
        Block here = world.m_8055_(pos).m_60734_();
        Block up = world.m_8055_(pos.m_7494_()).m_60734_();
        for (int i = 0; i < 8; ++i) {
            if (down instanceof PeatBlock) {
                return pos;
            }
            down = here;
            here = up;
            pos = pos.m_7494_();
            up = world.m_8055_(pos.m_7494_()).m_60734_();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState below = world.m_8055_(pos.m_7495_());
        return super.m_7898_(state, world, pos) && this.canBlockStay((Level)world, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.checkForDrop((Level)level, pos, state);
    }

    private boolean checkForDrop(Level world, BlockPos pos, BlockState state) {
        if (!this.canBlockStay(world, pos)) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(Level world, BlockPos pos) {
        return !world.m_46859_(pos.m_7495_());
    }
}

