/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.Embryoncis.EmbryoCalcificationMachine;

import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.Embryoncis.EmbryoCalcificationMachine.EmbryoCalcificationMachineMenu;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.inventory.EmbryoCalcificationMachineItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.DinosaurEggItem;
import net.vit.jurassicreborn.common.items.genetics.SyringeItem;
import org.jetbrains.annotations.NotNull;

public class EmbryoCalcificationMachineBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity {
    public static final int SLOTS = 3;
    public static final int STACK_PROCESS_TIME = 200;
    public static final int[] INPUTS = new int[]{0, 1};
    public static final int[] OUTPUTS = new int[]{2};
    private int processTime = 0;
    protected final EmbryoCalcificationMachineItemHandler machineItemStackHandler = new EmbryoCalcificationMachineItemHandler(3, INPUTS, OUTPUTS);
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return EmbryoCalcificationMachineBlockEntity.this.processTime;
            }
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                EmbryoCalcificationMachineBlockEntity.this.processTime = pValue;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public EmbryoCalcificationMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.EMBRYO_CALCIFICATION_MACHINE_BLOCK_ENTITY_TYPE.get(), pPos, pBlockState);
        this.machineItemStackHandler.setChangeListener(() -> {
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        });
    }

    @Override
    public Tag getMachineData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("ProcessTime", this.processTime);
        return data;
    }

    @Override
    public void readMachineData(Tag data) {
        CompoundTag machineData = (CompoundTag)data;
        this.processTime = machineData.m_128451_("ProcessTime");
    }

    public boolean canPlaceItem(int slotID, @NotNull ItemStack itemstack) {
        if (Ints.asList((int[])INPUTS).contains(slotID)) {
            SyringeItem syringe;
            Item item;
            return slotID == 0 && (item = itemstack.m_41720_()) instanceof SyringeItem && (syringe = (SyringeItem)item).getDinosaur(itemstack).getBirthType() == Dinosaur.BirthType.EGG_LAYING || slotID == 1 && itemstack.m_41720_() == Items.f_42521_;
        }
        return false;
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.embryo_calcification_machine");
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new EmbryoCalcificationMachineMenu(pContainerId, this.machineItemStackHandler, this.data, pInventory);
    }

    @Override
    public boolean canProcess(ItemStack ... stacks) {
        Item item;
        ItemStack input = stacks[0];
        ItemStack egg = stacks[1];
        ItemStack outputStack = stacks[2];
        if (!input.m_41619_() && (item = input.m_41720_()) instanceof SyringeItem) {
            Dinosaur dino;
            SyringeItem syringe = (SyringeItem)item;
            if (!(egg.m_41619_() || egg.m_41720_() != Items.f_42521_ || (dino = syringe.getDinosaur(input)).getBirthType() != Dinosaur.BirthType.EGG_LAYING || dino.isMarineCreature() && dino != DinosaurHandler.CALYMENE && dino != DinosaurHandler.BEELZEBUFO)) {
                if (!outputStack.m_41619_()) {
                    DinosaurEggItem outputItem = (DinosaurEggItem)outputStack.m_41720_();
                    return ((Object)((Object)outputItem)).equals(ModItems.dinoEggs.get(dino).get());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... stacks) {
        Item item;
        ItemStack input = stacks[0];
        ItemStack egg = stacks[1];
        ItemStack outputStack = stacks[2];
        if (!input.m_41619_() && (item = input.m_41720_()) instanceof SyringeItem) {
            SyringeItem syringe = (SyringeItem)item;
            ItemStack output = ((DinosaurEggItem)((Object)ModItems.dinoEggs.get(syringe.getDinosaur(input)).get())).m_7968_();
            output.m_41751_(input.m_41783_());
            return List.of(output);
        }
        return List.of(ItemStack.f_41583_);
    }

    public ItemStack[] collectInputs(int ... flags) {
        return new ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)};
    }

    public static void tick(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull EmbryoCalcificationMachineBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        ItemStack[] inputs = pBlockEntity.collectInputs(new int[0]);
        if (pBlockEntity.processTime >= 200 && pBlockEntity.canProcess(inputs)) {
            ItemStack output = pBlockEntity.processItem(inputs).get(0);
            pBlockEntity.mergeStack(2, output);
            pBlockEntity.decreaseStackSize(0);
            pBlockEntity.decreaseStackSize(1);
            pBlockEntity.processTime = 0;
            inputs = pBlockEntity.collectInputs(new int[0]);
        }
        pBlockEntity.processTime = pBlockEntity.canProcess(inputs) ? ++pBlockEntity.processTime : 0;
    }

    private void decreaseStackSize(int slot) {
        ItemStack stack = this.getItem(slot);
        stack.m_41774_(1);
        if (stack.m_41613_() <= 0) {
            this.setItem(slot, ItemStack.f_41583_);
        }
    }
}

