/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.feeder;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlock;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederMenu;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.util.networking.BlockUpdateUtils;
import net.vit.jurassicreborn.common.util.networking.Syncable;
import org.jetbrains.annotations.Nullable;

public class FeederBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
Syncable {
    public static final int meatSlot = 8;
    public static final int plantSlot = 17;
    public AABB feederBoundingBox;
    public int prevOpenAnimation;
    public int openAnimation;
    private NonNullList<ItemStack> slots = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    private int stayOpen;
    private boolean open;
    private DinosaurEntity feeding;
    private int feedingExpire;
    private ArrayList<DinosaurEntity> prospectiveFeeders = new ArrayList();
    private int scanCooldown = 0;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int idx) {
            return 0;
        }

        public void m_8050_(int idx, int val) {
        }

        public int m_6499_() {
            return 0;
        }
    };

    protected FeederBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.feederBoundingBox = new AABB(pos).m_82400_(32.0);
    }

    public FeederBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FEEDER.get(), pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.slots;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.slots = stacks;
    }

    public void m_6836_(int slot, ItemStack stack) {
        super.m_6836_(slot, stack);
        this.m_6596_();
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"Feeder");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new FeederMenu(id, playerInv, (Container)this, this.dataAccess);
    }

    public boolean isStockedFor(DinosaurEntity dino) {
        return this.getFood(dino) != -1;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new FeederMenu(id, playerInv, (Container)this, this.dataAccess);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = super.m_7407_(slot, amount);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            BlockUpdateUtils.sendBlockEntityUpdate(this.f_58857_, this.f_58858_);
        }
    }

    public int m_6643_() {
        return 18;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.slots.clear();
    }

    public boolean m_7983_() {
        for (ItemStack s : this.slots) {
            if (s.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void setOpen(boolean open) {
        if (!this.f_58857_.f_46443_ && this.open != open) {
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 0, open ? 1 : 0);
        }
        this.open = open;
        if (!open) {
            this.feeding = null;
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 0) {
            this.open = type == 1;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        for (int i = 0; i < 18; ++i) {
            fields.add(this.slots.get(i));
        }
        return fields;
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
    }

    public void tick(Level world, BlockPos pos, BlockState state, FeederBlockEntity instance) {
        if (this.f_58857_ == null) {
            return;
        }
        this.feederBoundingBox = new AABB(pos).m_82400_(32.0);
        if (--this.scanCooldown <= 0) {
            this.refreshProspectiveFeeders(world);
            this.scanCooldown = 20;
        }
        this.prevOpenAnimation = this.openAnimation;
        if (this.open && this.openAnimation < 20) {
            ++this.openAnimation;
        } else if (!this.open && this.openAnimation > 0) {
            --this.openAnimation;
        }
        if (this.open && this.openAnimation == 19) {
            this.stayOpen = 20;
        }
        if (this.feeding != null && (this.feeding.isCarcass() || this.feeding.m_21224_())) {
            this.feeding = null;
        }
        if (this.feeding != null) {
            if (this.feedingExpire > 0) {
                --this.feedingExpire;
            } else {
                this.feeding = null;
            }
        }
        if (this.open && this.openAnimation == 20) {
            if (this.stayOpen > 0) {
                --this.stayOpen;
                if (this.stayOpen == 10 && this.feeding != null) {
                    int feedSlot = this.getFood(this.feeding);
                    if (feedSlot >= 0) {
                        ItemStack stack = (ItemStack)this.slots.get(feedSlot);
                        if (!stack.m_41619_()) {
                            if (this.spawnOneItemTowardsFace(feedSlot, stack)) {
                                this.feeding = null;
                            } else {
                                this.stayOpen = Math.max(this.stayOpen, 12);
                            }
                        } else {
                            this.feeding = null;
                        }
                    } else {
                        this.feeding = null;
                    }
                }
            } else if (!this.f_58857_.f_46443_) {
                this.open = false;
            }
        }
    }

    private boolean spawnOneItemTowardsFace(int feedSlot, ItemStack stack) {
        boolean duplicateOnGround;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        Direction face = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)FeederBlock.FACING);
        Random random = new Random();
        float ox = 0.5f;
        float oy = 0.5f;
        float oz = 0.5f;
        float mx = 0.0f;
        float my = 0.0f;
        float mz = 0.0f;
        switch (face) {
            case UP: {
                oy = 1.0f;
                my = 1.0f;
                mx = random.nextFloat() - 0.5f;
                mz = random.nextFloat() - 0.5f;
                break;
            }
            case DOWN: {
                oy = -1.0f;
                break;
            }
            case NORTH: {
                oz = -1.0f;
                my = 0.5f;
                mz = -0.5f;
                break;
            }
            case SOUTH: {
                oz = 1.0f;
                my = 0.5f;
                mz = 0.5f;
                break;
            }
            case WEST: {
                ox = -1.0f;
                my = 0.5f;
                mx = -0.5f;
                break;
            }
            case EAST: {
                ox = 1.0f;
                my = 0.5f;
                mx = 0.5f;
            }
        }
        double spawnX = (float)this.m_58899_().m_123341_() + ox;
        double spawnY = (float)this.m_58899_().m_123342_() + oy;
        double spawnZ = (float)this.m_58899_().m_123343_() + oz;
        double duplicateRadius = 0.75;
        AABB duplicateCheck = new AABB(spawnX - duplicateRadius, spawnY - duplicateRadius, spawnZ - duplicateRadius, spawnX + duplicateRadius, spawnY + duplicateRadius, spawnZ + duplicateRadius);
        boolean bl = duplicateOnGround = !this.f_58857_.m_6443_(ItemEntity.class, duplicateCheck, ie -> !ie.m_32055_().m_41619_() && ItemStack.m_150942_((ItemStack)ie.m_32055_(), (ItemStack)stack)).isEmpty();
        if (duplicateOnGround) {
            return false;
        }
        ItemStack out = new ItemStack((ItemLike)stack.m_41720_(), 1);
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, spawnX, spawnY, spawnZ, out);
        itemEntity.m_32060_();
        float vx = mx * 0.3f;
        float vy = my * 0.3f;
        float vz = mz * 0.3f;
        itemEntity.m_20334_((double)vx, (double)vy, (double)vz);
        this.f_58857_.m_7967_((Entity)itemEntity);
        this.m_7407_(feedSlot, 1);
        if (this.feeding != null) {
            this.feeding.m_21573_().m_26519_(itemEntity.m_20185_() + (double)vx, itemEntity.m_20186_() + (double)vy, itemEntity.m_20189_() + (double)vz, 0.8);
        }
        return true;
    }

    private void refreshProspectiveFeeders(Level world) {
        List nearby = world.m_45976_(DinosaurEntity.class, this.feederBoundingBox);
        this.prospectiveFeeders = new ArrayList(nearby);
    }

    public int getFood(DinosaurEntity feeding) {
        if (feeding == null) {
            return -1;
        }
        for (int i = 0; i <= 17; ++i) {
            ItemStack st = this.m_8020_(i);
            if (st.m_41619_() || !FoodHelper.isEdible(feeding, feeding.getDinosaur().getDiet(), st.m_41720_())) continue;
            return i;
        }
        return -1;
    }

    public boolean canFeedDinosaur(DinosaurEntity dinosaur) {
        return this.getFoodForDinosaur(dinosaur) != -1;
    }

    private int getFoodForDinosaur(DinosaurEntity dinosaur) {
        int i = 0;
        for (ItemStack stack : this.slots) {
            Dinosaur meta;
            if (!stack.m_41619_() && FoodHelper.isEdible(dinosaur, (meta = dinosaur.getDinosaur()).getDiet(), stack.m_41720_())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setFeeding(@Nullable DinosaurEntity feeding) {
        this.feeding = feeding;
        this.feedingExpire = feeding != null ? 400 : 0;
    }

    @Nullable
    public DinosaurEntity getFeeding() {
        return this.feeding;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean isItemValidForSlot(int slotID, ItemStack itemstack) {
        if (itemstack == null || itemstack.m_41619_()) {
            return false;
        }
        if (FeederBlockEntity.isMeatSlot(slotID)) {
            return FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.MEAT) || FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.FISH) || FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.INSECT) || FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.FILTER);
        }
        if (FeederBlockEntity.isPlantSlot(slotID)) {
            return FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.PLANT) || FoodHelper.isFoodType(itemstack.m_41720_(), FoodType.FILTER);
        }
        return false;
    }

    public static boolean isMeatSlot(int slot) {
        return slot >= 0 && slot <= 8;
    }

    public static boolean isPlantSlot(int slot) {
        return slot >= 9 && slot <= 17;
    }

    public int[] m_7071_(Direction side) {
        int[] out = new int[18];
        for (int i = 0; i < 18; ++i) {
            out[i] = i;
        }
        return out;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag items = new ListTag();
        for (int i = 0; i < this.slots.size(); ++i) {
            ItemStack st = (ItemStack)this.slots.get(i);
            if (st.m_41619_()) continue;
            CompoundTag it = new CompoundTag();
            it.m_128344_("Slot", (byte)i);
            st.m_41739_(it);
            items.add((Object)it);
        }
        tag.m_128365_("Items", (Tag)items);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.slots = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ListTag items = tag.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag it = items.m_128728_(i);
            int slot = it.m_128445_("Slot") & 0xFF;
            if (slot < 0 || slot >= this.slots.size()) continue;
            this.slots.set(slot, (Object)ItemStack.m_41712_((CompoundTag)it));
        }
    }
}

