/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.grinder;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import net.vit.jurassicreborn.common.blocks.entities.ModMenuTypes;
import net.vit.jurassicreborn.common.blocks.inventory.FossilGrinderItemHandler;
import net.vit.jurassicreborn.common.util.api.GrindableItem;
import org.jetbrains.annotations.NotNull;

public class FossilGrinderMenu
extends AbstractContainerMenu {
    private final MachineItemStackHandler fossilGrinder;
    private final ContainerData data;

    public FossilGrinderMenu(int pContainerId, Inventory playerInv) {
        this(pContainerId, playerInv, FossilGrinderItemHandler.instance(), (ContainerData)new SimpleContainerData(1));
    }

    public FossilGrinderMenu(int pContainerId, Inventory playerInventory, MachineItemStackHandler fossilGrinder, ContainerData grinderData) {
        super((MenuType)ModMenuTypes.FOSSIL_GRINDER.get(), pContainerId);
        this.fossilGrinder = fossilGrinder;
        this.data = grinderData;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 0, 23, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 3, 23, 44));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 1, 41, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 4, 41, 44));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 2, 59, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 5, 59, 44));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 6, 108, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 9, 108, 44));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 7, 126, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 10, 126, 44));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 8, 144, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)fossilGrinder, 11, 144, 44));
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
        this.m_38884_(grinderData);
    }

    public int getField(int index) {
        return this.data.m_6413_(index);
    }

    public void setField(int index, int value) {
        this.data.m_8050_(index, value);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        ItemStack transferred = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        int otherSlots = this.f_38839_.size() - 36;
        if (slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            transferred = current.m_41777_();
            if (slotIndex < otherSlots ? !this.m_38903_(current, otherSlots, this.f_38839_.size(), true) : !this.m_38903_(current, 0, otherSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (current.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return transferred;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return true;
    }

    public static class GrindableItemSlot
    extends Slot {
        public GrindableItemSlot(Container inventory, int slotIndex, int xPosition, int yPosition) {
            super(inventory, slotIndex, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            GrindableItem grindableItem = GrindableItem.getGrindableItem(stack);
            return grindableItem != null && grindableItem.isGrindable(stack);
        }
    }
}

