/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.skeletonassembly;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblerItemHandler;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblerMenu;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonRecipeHelper;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SkeletonAssemblerBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity,
GeoBlockEntity {
    public static final int GRID_W = 5;
    public static final int GRID_H = 5;
    private static final int GRID_SLOTS = 25;
    public static final int RESULT_SLOT = 25;
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.model.idle");
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final SkeletonAssemblerItemHandler items = new SkeletonAssemblerItemHandler();
    private int progress = 0;
    private int maxProgress = 200;
    private int[] cachedBounds = new int[4];
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int i) {
            return i == 0 ? SkeletonAssemblerBlockEntity.this.progress : SkeletonAssemblerBlockEntity.this.maxProgress;
        }

        public void m_8050_(int i, int v) {
            if (i == 0) {
                SkeletonAssemblerBlockEntity.this.progress = v;
            } else {
                SkeletonAssemblerBlockEntity.this.maxProgress = v;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.items;
    }

    public SkeletonAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SKELETON_ASSEMBLY_ENTITY.get(), pos, state);
    }

    @Override
    public Tag getMachineData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Prog", this.progress);
        nbt.m_128385_("Bounds", this.cachedBounds);
        return nbt;
    }

    @Override
    public void readMachineData(Tag tag) {
        CompoundTag n = (CompoundTag)tag;
        this.progress = n.m_128451_("Prog");
        int[] b = n.m_128465_("Bounds");
        if (b.length == 4) {
            this.cachedBounds = b;
        }
    }

    public static void tick(Level lvl, BlockPos pos, BlockState st, SkeletonAssemblerBlockEntity be) {
        if (lvl.f_46443_) {
            return;
        }
        if (be.hasValidRecipe()) {
            ++be.progress;
            if (be.progress >= be.maxProgress) {
                be.craft();
                be.progress = 0;
            }
        } else {
            be.progress = 0;
        }
        be.m_6596_();
    }

    private boolean hasValidRecipe() {
        ItemStack resultItem = this.items.getStackInSlot(25);
        if (!resultItem.m_41619_()) {
            if (!SkeletonRecipeHelper.tryMatch((IItemHandler)this.items).success()) {
                this.items.setStackInSlot(25, ItemStack.f_41583_);
            }
            return false;
        }
        return false;
    }

    private void craft() {
        SkeletonRecipeHelper.Result result = SkeletonRecipeHelper.tryMatch((IItemHandler)this.items);
        if (!result.success()) {
            return;
        }
        if (!this.items.getStackInSlot(25).m_41619_()) {
            return;
        }
        int[] b = result.bounds();
        for (int y = b[1]; y <= b[3]; ++y) {
            for (int x = b[0]; x <= b[2]; ++x) {
                this.items.setStackInSlot(x + y * 5, ItemStack.f_41583_);
            }
        }
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.jurassicreborn.skeleton_assembly");
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        return List.of();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new SkeletonAssemblerMenu(id, inv, (IItemHandlerModifiable)this.items, this.data, this.m_58899_());
    }

    public boolean m_8077_() {
        return super.m_8077_();
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(IDLE_ANIMATION))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }
}

