/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.parkBlocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.common.blocks.parkBlocks.BenchPart;
import net.vit.jurassicreborn.common.entities.ParkBenchSeatLeftEntity;
import net.vit.jurassicreborn.common.entities.ParkBenchSeatRightEntity;

public class ParkBenchBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BenchPart> PART = EnumProperty.m_61587_((String)"part", BenchPart.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ParkBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)BenchPart.LEFT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{FACING, PART});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState out = (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_(facing));
        if (mirror == Mirror.LEFT_RIGHT) {
            BenchPart part = (BenchPart)((Object)out.m_61143_(PART));
            out = (BlockState)out.m_61124_(PART, (Comparable)((Object)(part == BenchPart.LEFT ? BenchPart.RIGHT : BenchPart.LEFT)));
        }
        return out;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        Direction perp = facing.m_122427_();
        BlockPos pos = ctx.m_8083_();
        BlockPos other = pos.m_121945_(perp);
        if (!ctx.m_43725_().m_8055_(other).m_60629_(ctx)) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)BenchPart.LEFT));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction perp = facing.m_122427_();
        BlockPos other = pos.m_121945_(perp);
        BlockState rightHalf = (BlockState)state.m_61124_(PART, (Comparable)((Object)BenchPart.RIGHT));
        level.m_7731_(other, rightHalf, 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BenchPart part = (BenchPart)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction perp = facing.m_122427_();
        BlockPos otherPos = part == BenchPart.LEFT ? pos.m_121945_(perp) : pos.m_121945_(perp.m_122424_());
        BlockState other = level.m_8055_(otherPos);
        if (!level.f_46443_ && !player.m_7500_()) {
            BlockPos dropAt = part == BenchPart.LEFT ? pos : otherPos;
            ParkBenchBlock.m_49840_((Level)level, (BlockPos)dropAt, (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
        }
        if (other.m_60713_((Block)this) && other.m_61143_(PART) != part && !level.f_46443_) {
            level.m_46953_(otherPos, false, (Entity)player);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack tool) {
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockPos expectedPartner;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction perp = facing.m_122427_();
        BenchPart part = (BenchPart)((Object)state.m_61143_(PART));
        BlockPos blockPos = expectedPartner = part == BenchPart.LEFT ? pos.m_121945_(perp) : pos.m_121945_(perp.m_122424_());
        if (neighborPos.equals((Object)expectedPartner) && (!neighbor.m_60713_((Block)this) || neighbor.m_61143_(PART) == part || neighbor.m_61143_((Property)FACING) != facing)) {
            level.m_7471_(pos, false);
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter g, BlockPos pos, CollisionContext c) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter g, BlockPos pos, CollisionContext c) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_20159_()) {
            return InteractionResult.PASS;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction perp = facing.m_122427_();
        BenchPart part = (BenchPart)((Object)state.m_61143_(PART));
        double side = 0.0;
        double depth = -0.2;
        double leftX = (double)perp.m_122429_() * -0.0 + (double)facing.m_122429_() * -0.2;
        double leftZ = (double)perp.m_122431_() * -0.0 + (double)facing.m_122431_() * -0.2;
        double rightX = (double)perp.m_122429_() * 0.0 + (double)facing.m_122429_() * -0.2;
        double rightZ = (double)perp.m_122431_() * 0.0 + (double)facing.m_122431_() * -0.2;
        if (part == BenchPart.LEFT) {
            if (this.tryMountLeft(level, pos, facing, leftX, leftZ, player)) {
                return InteractionResult.m_19078_((boolean)false);
            }
            if (this.tryMountRight(level, pos, facing, rightX, rightZ, player)) {
                return InteractionResult.m_19078_((boolean)false);
            }
        } else {
            if (this.tryMountRight(level, pos, facing, rightX, rightZ, player)) {
                return InteractionResult.m_19078_((boolean)false);
            }
            if (this.tryMountLeft(level, pos, facing, leftX, leftZ, player)) {
                return InteractionResult.m_19078_((boolean)false);
            }
        }
        return InteractionResult.PASS;
    }

    private boolean tryMountLeft(Level level, BlockPos pos, Direction facing, double xOff, double zOff, Player player) {
        ParkBenchSeatLeftEntity seat = this.getOrCreateLeftSeat(level, pos, facing, xOff, zOff);
        if (seat != null && seat.m_20197_().isEmpty()) {
            player.m_7998_((Entity)seat, true);
            return true;
        }
        return false;
    }

    private boolean tryMountRight(Level level, BlockPos pos, Direction facing, double xOff, double zOff, Player player) {
        ParkBenchSeatRightEntity seat = this.getOrCreateRightSeat(level, pos, facing, xOff, zOff);
        if (seat != null && seat.m_20197_().isEmpty()) {
            player.m_7998_((Entity)seat, true);
            return true;
        }
        return false;
    }

    private ParkBenchSeatLeftEntity getOrCreateLeftSeat(Level level, BlockPos benchPos, Direction facing, double xOff, double zOff) {
        Vec3 seatPos = new Vec3((double)benchPos.m_123341_() + 0.5 + xOff, (double)benchPos.m_123342_() + 0.3, (double)benchPos.m_123343_() + 0.5 + zOff);
        ParkBenchSeatLeftEntity existing = level.m_45976_(ParkBenchSeatLeftEntity.class, new AABB(seatPos.f_82479_ - 0.12, seatPos.f_82480_ - 0.12, seatPos.f_82481_ - 0.12, seatPos.f_82479_ + 0.12, seatPos.f_82480_ + 0.12, seatPos.f_82481_ + 0.12)).stream().findFirst().orElse(null);
        if (existing != null) {
            return existing;
        }
        ParkBenchSeatLeftEntity seat = new ParkBenchSeatLeftEntity(level, benchPos, xOff, zOff);
        seat.m_146922_(facing.m_122435_());
        level.m_7967_((Entity)seat);
        return seat;
    }

    private ParkBenchSeatRightEntity getOrCreateRightSeat(Level level, BlockPos benchPos, Direction facing, double xOff, double zOff) {
        Vec3 seatPos = new Vec3((double)benchPos.m_123341_() + 0.5 + xOff, (double)benchPos.m_123342_() + 0.3, (double)benchPos.m_123343_() + 0.5 + zOff);
        ParkBenchSeatRightEntity existing = level.m_45976_(ParkBenchSeatRightEntity.class, new AABB(seatPos.f_82479_ - 0.12, seatPos.f_82480_ - 0.12, seatPos.f_82481_ - 0.12, seatPos.f_82479_ + 0.12, seatPos.f_82480_ + 0.12, seatPos.f_82481_ + 0.12)).stream().findFirst().orElse(null);
        if (existing != null) {
            return existing;
        }
        ParkBenchSeatRightEntity seat = new ParkBenchSeatRightEntity(level, benchPos, xOff, zOff);
        seat.m_146922_(facing.m_122435_());
        level.m_7967_((Entity)seat);
        return seat;
    }
}

