/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.datagen;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.wood.PetrifiedLogBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.datagen.ModBlockFamilies;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.items.ModItems;

public class JRItemModelProvider
extends ItemModelProvider {
    public JRItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jurassicreborn", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleBlockItem(((Block)ModBlocks.AMBER_ORE.get()).m_5456_());
        this.simpleBlockItem(((Block)ModBlocks.AMBER_BLOCK.get()).m_5456_());
        DinosaurHandler.doDinosInit();
        for (Dinosaur dinosaur : Dinosaur.DINOSAUR_IDS.keySet()) {
            if (dinosaur == Dinosaur.EMPTY) continue;
            String modelName = "spawn_egg/" + ModItems.getSpawnEggModelName(dinosaur);
            this.withExistingParent(modelName, this.mcLoc("item/template_spawn_egg"));
        }
        ModBlockFamilies.getAllFamilies().forEach(family -> {
            Block wall;
            Block fenceGate;
            FenceBlock fenceBlock;
            ButtonBlock buttonBlock;
            Block plate;
            Block stairs;
            Block slab;
            DoorBlock door;
            Block baseBlock = family.m_175951_();
            String name = this.name(baseBlock.m_5456_());
            TrapDoorBlock trapDoor = (TrapDoorBlock)family.m_175952_(BlockFamily.Variant.TRAPDOOR);
            if (trapDoor != null) {
                ResourceLocation trapDoorName = BuiltInRegistries.f_257033_.m_7981_((Object)trapDoor.m_5456_());
                String modelName = "block/" + trapDoorName.m_135815_() + "_bottom";
                this.simpleBlockItem(trapDoor.m_5456_(), this.modLoc(modelName));
            }
            if ((door = (DoorBlock)family.m_175952_(BlockFamily.Variant.DOOR)) != null) {
                this.generatedItem(door.m_5456_());
            }
            if ((slab = family.m_175952_(BlockFamily.Variant.SLAB)) != null) {
                this.simpleBlockItem(slab.m_5456_());
            }
            if ((stairs = family.m_175952_(BlockFamily.Variant.STAIRS)) != null) {
                this.simpleBlockItem(stairs.m_5456_());
            }
            if ((plate = family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE)) != null) {
                this.simpleBlockItem(plate.m_5456_());
            }
            if ((buttonBlock = (ButtonBlock)family.m_175952_(BlockFamily.Variant.BUTTON)) != null) {
                String buttonName = this.name(buttonBlock.m_5456_());
                this.buttonInventory(buttonName, this.modLoc("block/" + name));
            }
            if ((fenceBlock = (FenceBlock)family.m_175952_(BlockFamily.Variant.FENCE)) != null) {
                this.fenceInventory(this.name(fenceBlock.m_5456_()), this.modLoc("block/" + name));
            }
            if ((fenceGate = family.m_175952_(BlockFamily.Variant.FENCE_GATE)) != null) {
                this.simpleBlockItem(fenceGate.m_5456_());
            }
            if ((wall = family.m_175952_(BlockFamily.Variant.WALL)) != null) {
                this.wallInventory(this.name(wall.m_5456_()), this.modLoc("block/" + name));
            }
        });
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_ARAUCARIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_CALAMITES_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_GINKGO_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_MAGNOLIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_PHOENIX_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_PSARONIUS_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_ARAUCARIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_CALAMITES_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_GINKGO_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_MAGNOLIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_PHOENIX_LOG.get()).m_5456_());
        this.simpleBlockItem(((PetrifiedLogBlock)WoodBlocks.PETRIFIED_PSARONIUS_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.ARAUCARIA_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.CALAMITES_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.GINKGO_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.MAGNOLIA_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.PHOENIX_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.PSARONIUS_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_ARAUCARIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_CALAMITES_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_GINKGO_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_MAGNOLIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_PHOENIX_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_PSARONIUS_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_ARAUCARIA_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_CALAMITES_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_GINKGO_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_MAGNOLIA_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_PHOENIX_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.STRIPPED_PSARONIUS_WOOD.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.ARAUCARIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.CALAMITES_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.GINKGO_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.MAGNOLIA_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.PHOENIX_LOG.get()).m_5456_());
        this.simpleBlockItem(((RotatedPillarBlock)WoodBlocks.PSARONIUS_LOG.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.ARAUCARIA_SAPLING.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.CALAMITES_SAPLING.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.GINKGO_SAPLING.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.MAGNOLIA_SAPLING.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.PHOENIX_SAPLING.get()).m_5456_());
        this.generatedItemBlockTexture(((SaplingBlock)ModBlocks.PSARONIUS_SAPLING.get()).m_5456_());
        this.generatedItem((Item)ModItems.BLACK_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.BLUE_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.PINK_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.PURPLE_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.SORNA_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.LIME_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.GREEN_JEEP_WRANGLER.get());
        this.generatedItem((Item)ModItems.AMBER.get());
        this.boatItem((Item)ModItems.ARAUCARIA_BOAT.get());
        this.boatItem((Item)ModItems.ARAUCARIA_CHEST_BOAT.get());
        this.boatItem((Item)ModItems.CALAMITES_BOAT.get());
        this.boatItem((Item)ModItems.CALAMITES_CHEST_BOAT.get());
        this.boatItem((Item)ModItems.GINKGO_BOAT.get());
        this.boatItem((Item)ModItems.GINKGO_CHEST_BOAT.get());
        this.boatItem((Item)ModItems.MAGNOLIA_BOAT.get());
        this.boatItem((Item)ModItems.MAGNOLIA_CHEST_BOAT.get());
        this.boatItem((Item)ModItems.PHOENIX_BOAT.get());
        this.boatItem((Item)ModItems.PHOENIX_CHEST_BOAT.get());
        this.boatItem((Item)ModItems.PSARONIUS_BOAT.get());
        this.boatItem((Item)ModItems.PSARONIUS_CHEST_BOAT.get());
        this.generatedItem(((DoorBlock)ModBlocks.REINFORCED_DOOR.get()).m_5456_());
        this.generatedItem(((DoorBlock)ModBlocks.SECURITY_DOOR.get()).m_5456_());
    }

    protected void simpleBlockItem(Item item, ResourceLocation loc) {
        String s = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
        ((ItemModelBuilder)this.getBuilder(s)).parent((ModelFile)this.getExistingFile(loc));
    }

    protected String name(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
    }

    protected void simpleBlockItem(Item item) {
        this.simpleBlockItem(item, this.modLoc("block/" + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_()));
    }

    private void generatedItem(Item item, ResourceLocation texture) {
        String path = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", texture);
    }

    private void generatedItem(Item item) {
        this.generatedItem(item, this.modLoc("item/" + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_()));
    }

    private void generatedItemBlockTexture(Item item) {
        this.generatedItem(item, this.modLoc("block/" + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_()));
    }

    private void boatItem(Item item) {
        String path = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
    }
}

