/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlvarezsaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BeelzebufoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.SwimmingDinosaurEntity;

public class CalymeneEntity
extends SwimmingDinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CalymeneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ROLLED = SynchedEntityData.m_135353_(CalymeneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ON_BOTTOM = SynchedEntityData.m_135353_(CalymeneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double FLOOR_CLEARANCE = 0.06;
    private static final double CONTACT_EPSILON = 0.1;
    private static final int PANIC_ROLL_MIN = 60;
    private static final int PANIC_ROLL_VAR = 40;
    private static final int SWIM_BURST_MIN = 60;
    private static final int SWIM_BURST_VAR = 60;
    private static final float MAX_STEP_UP = 1.0f;
    private int rollTicks;
    private int panicTicks;
    private int swimBurstTicks;

    public CalymeneEntity(Level world, EntityType<CalymeneEntity> type) {
        super(world, (EntityType)type, DinosaurHandler.CALYMENE);
        this.target(AlvarezsaurusEntity.class, BeelzebufoEntity.class, Squid.class, Cod.class, Dolphin.class, Salmon.class, TropicalFish.class, Turtle.class, Axolotl.class, GlowSquid.class, Frog.class, Tadpole.class, CompsognathusEntity.class, LeptictidiumEntity.class);
        this.setVariant(this.m_217043_().m_188503_(4));
        this.f_19793_ = 1.0f;
        this.f_21345_.m_25352_(0, (Goal)new BottomCrawlGoal(this, 1.05, 8, 6));
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ROLLED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ON_BOTTOM, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        nbt.m_128405_("RollTicks", this.rollTicks);
        nbt.m_128405_("PanicTicks", this.panicTicks);
        nbt.m_128405_("SwimBurstTicks", this.swimBurstTicks);
    }

    public boolean isOnBottom() {
        return (Boolean)this.f_19804_.m_135370_(ON_BOTTOM);
    }

    private void setOnBottom(boolean v) {
        this.f_19804_.m_135381_(ON_BOTTOM, (Object)v);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
        this.rollTicks = nbt.m_128451_("RollTicks");
        this.panicTicks = nbt.m_128451_("PanicTicks");
        this.swimBurstTicks = nbt.m_128451_("SwimBurstTicks");
        this.setRolled(this.rollTicks > 0);
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public boolean isRolled() {
        return (Boolean)this.f_19804_.m_135370_(ROLLED);
    }

    public void setRolled(boolean v) {
        this.f_19804_.m_135381_(ROLLED, (Object)v);
    }

    public boolean isPanicking() {
        return this.panicTicks > 0 || this.m_5448_() != null;
    }

    private void startSwimBurst(RandomSource r) {
        this.swimBurstTicks = 60 + r.m_188503_(61);
    }

    public void triggerRoll(int durationTicks) {
        this.rollTicks = Math.max(this.rollTicks, durationTicks);
        this.setRolled(true);
        this.m_7910_(this.m_6113_() * 0.5f);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean res = super.m_6469_(source, amount);
        if (!this.f_19853_.f_46443_ && this.m_20069_() && !this.isCarcass()) {
            this.panicTicks = Math.max(this.panicTicks, 80 + this.m_217043_().m_188503_(80));
            if (this.m_21223_() / this.m_21233_() < 0.35f || this.m_217043_().m_188501_() < 0.2f) {
                this.triggerRoll(60 + this.m_217043_().m_188503_(41));
            }
            this.startSwimBurst(this.m_217043_());
        }
        return res;
    }

    @Override
    public void m_8119_() {
        double floorY;
        super.m_8119_();
        if (this.rollTicks > 0 && --this.rollTicks <= 0) {
            this.setRolled(false);
        }
        if (this.panicTicks > 0) {
            --this.panicTicks;
        }
        if (this.swimBurstTicks > 0) {
            --this.swimBurstTicks;
        }
        if (!this.f_19853_.f_46443_ && this.m_20069_() && !this.isCarcass() && this.swimBurstTicks == 0 && !Double.isNaN(floorY = this.findSeafloorY(this.m_20185_(), this.m_20186_(), this.m_20189_()))) {
            double targetY = floorY + 0.06;
            double dy = targetY - this.m_20186_();
            Vec3 vel = this.m_20184_();
            double correction = dy * 0.18 - vel.f_82480_ * 0.35;
            this.m_20334_(vel.f_82479_ * 0.92, vel.f_82480_ + correction, vel.f_82481_ * 0.92);
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_20069_() && !this.isCarcass()) {
            boolean hasFloor;
            if (this.swimBurstTicks > 0) {
                this.setOnBottom(false);
                super.m_7023_(vec);
                return;
            }
            double floorY = this.findSeafloorY(this.m_20185_(), this.m_20186_(), this.m_20189_());
            boolean bl = hasFloor = !Double.isNaN(floorY);
            if (!hasFloor) {
                this.setOnBottom(false);
                super.m_7023_(vec);
                return;
            }
            double targetY = floorY + 0.06;
            double dy = targetY - this.m_20186_();
            boolean onBottom = Math.abs(dy) <= 0.1 && !this.isRolled();
            this.setOnBottom(onBottom);
            if (onBottom) {
                this.m_19920_(0.1f, new Vec3((double)((float)vec.f_82479_), 0.0, (double)((float)vec.f_82481_)));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vel = this.m_20184_();
                double correction = dy * 0.22 - vel.f_82480_ * 0.45;
                vel = new Vec3(vel.f_82479_ * 0.86, vel.f_82480_ + correction, vel.f_82481_ * 0.86);
                if (dy > 0.0 && dy <= 1.01) {
                    double upBoost = Math.min(0.12, dy * 0.55);
                    vel = new Vec3(vel.f_82479_, Math.max(vel.f_82480_, upBoost), vel.f_82481_);
                }
                if (Math.abs(dy) < 0.05) {
                    vel = new Vec3(vel.f_82479_, vel.f_82480_ - 0.01, vel.f_82481_);
                }
                this.m_20256_(vel);
            } else {
                this.setOnBottom(false);
                super.m_7023_(vec);
            }
        } else {
            this.setOnBottom(false);
            super.m_7023_(vec);
        }
    }

    private double findSeafloorY(double x, double y, double z) {
        Level lvl = this.f_19853_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        int minY = lvl.m_141937_();
        int maxScan = 24;
        for (int steps = 0; steps < 24 && pos.m_123342_() > minY; ++steps) {
            boolean solidTopBelow;
            FluidState fluidHere = lvl.m_6425_((BlockPos)pos);
            BlockPos below = pos.m_7495_();
            BlockState belowState = lvl.m_8055_(below);
            boolean waterHere = !fluidHere.m_76178_();
            boolean bl = solidTopBelow = belowState.m_60819_().m_76178_() && belowState.m_60783_((BlockGetter)lvl, below, Direction.UP);
            if (waterHere && solidTopBelow) {
                return (double)below.m_123342_() + 1.0;
            }
            pos.m_122184_(0, -1, 0);
        }
        return Double.NaN;
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("brown");
            }
            case 1: {
                return this.texture("silver");
            }
            case 2: {
                return this.texture("purple");
            }
            case 3: 
        }
        return this.texture("tan");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }

    static class BottomCrawlGoal
    extends Goal {
        private final CalymeneEntity mob;
        private final double speed;
        private final int radius;
        private final int tries;
        private int cooldown;

        public BottomCrawlGoal(CalymeneEntity mob, double speed, int radius, int tries) {
            this.mob = mob;
            this.speed = speed;
            this.radius = radius;
            this.tries = tries;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.m_20069_() || this.mob.isCarcass() || this.mob.isRolled()) {
                return false;
            }
            if (this.mob.swimBurstTicks > 0) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.mob.m_21573_().m_26571_() && this.mob.m_217043_().m_188501_() < 0.15f;
        }

        public void m_8056_() {
            this.cooldown = 20 + this.mob.m_217043_().m_188503_(20);
            RandomSource r = this.mob.m_217043_();
            BlockPos origin = this.mob.m_20183_();
            for (int i = 0; i < this.tries; ++i) {
                int dx = Mth.m_216271_((RandomSource)r, (int)(-this.radius), (int)this.radius);
                int dz = Mth.m_216271_((RandomSource)r, (int)(-this.radius), (int)this.radius);
                double floorY = this.mob.findSeafloorY((double)(origin.m_123341_() + dx) + 0.5, origin.m_123342_(), (double)(origin.m_123343_() + dz) + 0.5);
                if (Double.isNaN(floorY)) continue;
                double y = floorY + 0.06;
                this.mob.m_21573_().m_26519_((double)(origin.m_123341_() + dx) + 0.5, y, (double)(origin.m_123343_() + dz) + 0.5, this.speed);
                return;
            }
        }

        public boolean m_8045_() {
            return this.mob.m_20069_() && !this.mob.isCarcass() && this.mob.swimBurstTicks == 0 && !this.mob.m_21573_().m_26571_();
        }
    }
}

