/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class IndominusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> DATA_WATCHER_IS_CAMOUFLAGING = SynchedEntityData.m_135353_(IndominusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float[] newSkinColor = new float[3];
    private float[] skinColor = new float[3];
    private int stepCount = 0;
    private boolean isCamouflaging;

    public IndominusEntity(Level world, EntityType<IndominusEntity> type) {
        super(world, type, DinosaurHandler.INDOMINUS);
        this.target(LivingEntity.class, Player.class);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WATCHER_IS_CAMOUFLAGING, (Object)false);
    }

    @Override
    public void setupDisplay(boolean isMale) {
        super.setupDisplay(isMale);
        this.isCamouflaging = true;
        this.skinColor = new float[]{255.0f, 255.0f, 255.0f};
        this.newSkinColor = new float[]{255.0f, 255.0f, 255.0f};
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_20902_ > 0.0f && this.stepCount <= 0) {
            this.m_5496_(SoundHandler.STOMP, (float)this.interpolate(0.1f, 1.0), this.m_6100_());
            this.stepCount = 65;
        }
        this.stepCount = (int)((double)this.stepCount - (double)this.f_20902_ * 9.5);
        if (this.f_19853_.f_46443_) {
            this.isCamouflaging = (Boolean)this.f_19804_.m_135370_(DATA_WATCHER_IS_CAMOUFLAGING);
            this.changeSkinColor();
        } else {
            this.f_19804_.m_135381_(DATA_WATCHER_IS_CAMOUFLAGING, (Object)this.isCamouflaging);
        }
    }

    @Override
    public float m_6121_() {
        return (float)this.interpolate(0.9f, 1.6f) + (this.f_19796_.m_188501_() - 0.5f) * 0.125f;
    }

    public boolean isCamouflaging() {
        return this.isCamouflaging;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void changeSkinColor() {
        int color;
        BlockPos pos = new BlockPos((Vec3i)this.m_20097_()).m_121945_(Direction.DOWN);
        BlockState state = this.f_19853_.m_8055_(pos);
        if (this.isCamouflaging()) {
            color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)this.f_19853_, pos, 0);
            if (color == 0xFFFFFF) {
                color = state.m_60780_((BlockGetter)this.f_19853_, (BlockPos)pos).f_76396_;
            }
        } else {
            color = 0xFFFFFF;
        }
        if (color != 0) {
            this.newSkinColor[0] = color >> 16 & 0xFF;
            this.newSkinColor[1] = color >> 8 & 0xFF;
            this.newSkinColor[2] = color & 0xFF;
            if (this.skinColor[0] == 0.0f && this.skinColor[1] == 0.0f && this.skinColor[2] == 0.0f) {
                this.skinColor[0] = this.newSkinColor[0];
                this.skinColor[1] = this.newSkinColor[1];
                this.skinColor[2] = this.newSkinColor[2];
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.skinColor[i] < this.newSkinColor[i]) {
                int n = i;
                this.skinColor[n] = this.skinColor[n] + 1.0f;
            }
            if (!(this.skinColor[i] > this.newSkinColor[i])) continue;
            int n = i;
            this.skinColor[n] = this.skinColor[n] - 1.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getSkinColor() {
        return new float[]{this.skinColor[0] / 255.0f, this.skinColor[1] / 255.0f, this.skinColor[2] / 255.0f};
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.INDOMINUS_LIVING;
            }
            case DYING: {
                return SoundHandler.INDOMINUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.INDOMINUS_HURT;
            }
            case ROARING: {
                return SoundHandler.INDOMINUS_ROAR;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.INDOMINUS_BREATHING;
    }
}

